/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.loader;

import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.loader.Loader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathLoader
implements Loader {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathLoader.class);
    private String prefix;
    private String suffix;
    private String charset = "UTF-8";
    private final ClassLoader rcl;

    public ClasspathLoader(ClassLoader classLoader) {
        this.rcl = classLoader;
    }

    public ClasspathLoader() {
        this(ClasspathLoader.class.getClassLoader());
    }

    @Override
    public Reader getReader(String templateName) throws LoaderException {
        InputStreamReader isr = null;
        BufferedReader reader = null;
        InputStream is = null;
        StringBuilder path = new StringBuilder("");
        if (this.getPrefix() != null) {
            path.append(this.getPrefix());
            if (!this.getPrefix().endsWith("/")) {
                path.append("/");
            }
        }
        String location = path.toString() + templateName + (this.getSuffix() == null ? "" : this.getSuffix());
        logger.debug("Looking for template in {}.", (Object)location);
        is = this.rcl.getResourceAsStream(location);
        if (is == null) {
            throw new LoaderException(null, "Could not find template \"" + location + "\"");
        }
        try {
            isr = new InputStreamReader(is, this.charset);
            reader = new BufferedReader(isr);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return reader;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }
}

