/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.template;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.node.RootNode;
import com.mitchellbosecke.pebble.template.Block;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.Macro;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.mitchellbosecke.pebble.template.ScopeChain;
import com.mitchellbosecke.pebble.utils.FutureWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PebbleTemplateImpl
implements PebbleTemplate {
    protected final PebbleEngine engine;
    private final Map<String, Block> blocks = new HashMap<String, Block>();
    private final Map<String, Macro> macros = new HashMap<String, Macro>();
    private final RootNode rootNode;
    private final String name;

    public PebbleTemplateImpl(PebbleEngine engine, RootNode root, String name) throws PebbleException {
        this.engine = engine;
        this.rootNode = root;
        this.name = name;
    }

    public void buildContent(Writer writer, EvaluationContext context) throws IOException, PebbleException {
        this.rootNode.render(this, writer, context);
        if (context.getParentTemplate() != null) {
            PebbleTemplateImpl parent = context.getParentTemplate();
            context.ascendInheritanceChain();
            parent.buildContent(writer, context);
        }
    }

    @Override
    public void evaluate(Writer writer) throws PebbleException, IOException {
        EvaluationContext context = this.initContext(null, null);
        this.evaluate(writer, context);
    }

    @Override
    public void evaluate(Writer writer, Locale locale) throws PebbleException, IOException {
        EvaluationContext context = this.initContext(null, locale);
        this.evaluate(writer, context);
    }

    @Override
    public void evaluate(Writer writer, Map<String, Object> map) throws PebbleException, IOException {
        EvaluationContext context = this.initContext(map, null);
        context.pushScope(map);
        this.evaluate(writer, context);
    }

    @Override
    public void evaluate(Writer writer, Map<String, Object> map, Locale locale) throws PebbleException, IOException {
        EvaluationContext context = this.initContext(map, locale);
        context.pushScope(map);
        this.evaluate(writer, context);
    }

    public void evaluate(Writer writer, EvaluationContext context) throws PebbleException, IOException {
        if (context.getExecutorService() != null) {
            writer = new FutureWriter(writer);
        }
        this.buildContent(writer, context);
        writer.flush();
    }

    private EvaluationContext initContext(Map<String, Object> map, Locale locale) {
        locale = locale == null ? this.engine.getDefaultLocale() : locale;
        ScopeChain scopeChain = new ScopeChain(this.engine.getGlobalVariables());
        EvaluationContext context = new EvaluationContext(this, this.engine.isStrictVariables(), locale, this.engine.getFilters(), this.engine.getTests(), this.engine.getFunctions(), this.engine.getExecutorService(), scopeChain, null);
        return context;
    }

    public void importTemplate(EvaluationContext context, String name) throws PebbleException {
        context.addImportedTemplate((PebbleTemplateImpl)this.engine.getTemplate(name));
    }

    public void includeTemplate(Writer writer, EvaluationContext context, String name) throws PebbleException, IOException {
        PebbleTemplateImpl template = (PebbleTemplateImpl)this.engine.getTemplate(name);
        EvaluationContext newContext = context.shallowCopyWithoutInheritanceChain(template);
        template.evaluate(writer, newContext);
    }

    public boolean hasMacro(String macroName) {
        return this.macros.containsKey(macroName);
    }

    public void registerBlock(Block block) {
        this.blocks.put(block.getName(), block);
    }

    public boolean hasBlock(String blockName) {
        return this.blocks.containsKey(blockName);
    }

    public void registerMacro(Macro macro) throws PebbleException {
        if (this.macros.containsKey(macro.getName())) {
            throw new PebbleException(null, "More than one macro can not share the same name: " + macro.getName());
        }
        this.macros.put(macro.getName(), macro);
    }

    public void block(Writer writer, EvaluationContext context, String blockName, boolean ignoreOverriden) throws PebbleException, IOException {
        PebbleTemplateImpl childTemplate = context.getChildTemplate();
        if (!ignoreOverriden && childTemplate != null) {
            context.descendInheritanceChain();
            childTemplate.block(writer, context, blockName, false);
            context.ascendInheritanceChain();
        } else if (this.blocks.containsKey(blockName)) {
            Block block = this.blocks.get(blockName);
            block.evaluate(this, writer, context);
        } else if (context.getParentTemplate() != null) {
            PebbleTemplateImpl parent = context.getParentTemplate();
            context.ascendInheritanceChain();
            parent.block(writer, context, blockName, true);
            context.descendInheritanceChain();
        }
    }

    public String macro(EvaluationContext context, String macroName, ArgumentsNode args, boolean ignoreOverriden) throws PebbleException {
        String result = null;
        boolean found = false;
        PebbleTemplateImpl childTemplate = context.getChildTemplate();
        if (!ignoreOverriden && childTemplate != null) {
            found = true;
            context.descendInheritanceChain();
            result = childTemplate.macro(context, macroName, args, false);
            context.ascendInheritanceChain();
        } else if (this.hasMacro(macroName)) {
            found = true;
            Macro macro = this.macros.get(macroName);
            Map<String, Object> namedArguments = args.getArgumentMap(this, context, macro);
            result = macro.call(this, context, namedArguments);
        }
        if (!found) {
            for (PebbleTemplateImpl template : context.getImportedTemplates()) {
                if (!template.hasMacro(macroName)) continue;
                found = true;
                result = template.macro(context, macroName, args, false);
            }
        }
        if (!found) {
            if (context.getParentTemplate() != null) {
                PebbleTemplateImpl parent = context.getParentTemplate();
                context.ascendInheritanceChain();
                result = parent.macro(context, macroName, args, true);
                context.descendInheritanceChain();
            } else {
                throw new PebbleException(null, String.format("Function or Macro [%s] does not exist.", macroName));
            }
        }
        return result;
    }

    public void setParent(EvaluationContext context, String parentName) throws PebbleException {
        context.setParent((PebbleTemplateImpl)this.engine.getTemplate(parentName));
    }

    public String getName() {
        return this.name;
    }
}

