/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands.ide;

import com.mks.api.commands.ide.WorkingFileFactory;
import com.mks.api.response.APIError;
import com.mks.api.response.APIException;
import com.mks.api.response.Field;
import com.mks.api.response.InvalidItemException;
import com.mks.api.response.Item;
import com.mks.api.response.ItemNotFoundException;
import com.mks.api.response.WorkItem;
import com.mks.api.response.impl.SimpleResponseFactory;
import com.mks.api.response.modifiable.ModifiableField;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class WorkingFile
implements Item {
    public static final String INVALID_MOVE_TO_CP_OPERATION = "INVALID_MOVE_TO_CP_OPERATION";
    private long ordinal;
    private boolean valid;
    private static final String WF_FIELD_EXCLUSIVE_LOCKED_BY_OTHER = "exclusiveLockedByOther";
    private static final String WF_FIELD_LOCKED_BY_OTHER = "lockedByOther";
    private static final String WF_FIELD_LOCKED_BY_ME = "lockedByMe";
    private static final String WF_FIELD_OUT_OF_DATE = "outOfDate";
    private static final String WF_FIELD_MODIFIED = "modified";
    private static final String WF_FIELD_INCOMING = "incoming";
    private static final String WF_FIELD_MOVED = "moved";
    private static final String WF_FIELD_DROPPED = "dropped";
    private static final String WF_FIELD_ADDED = "added";
    private static final String WF_FIELD_FORMER_MEMBER = "formerMember";
    private static final String WF_FIELD_MEMBER = "member";
    private static final String WF_FIELD_CONTROLLED = "controlled";
    private static final String WF_FIELD_IN_SANDBOX_DIR = "inSandboxDir";
    private static final String WF_FIELD_WORKING_DELTA = "workingDelta";
    private static final String WF_FIELD_WORKING_CPID = "workingCpid";
    private static final String WF_FIELD_WORKING_REV = "workingRev";
    private static final String WF_FIELD_MEMBER_REV = "memberRev";
    private static final String WF_FIELD_SANDBOX = "sandbox";
    private static final String WF_FIELD_IS_SHARED = "shared";
    private static final String WF_FIELD_MEMBER_NAME = "memberName";
    private static final String WF_FIELD_IS_PENDING = "pending";
    private static final String WF_FIELD_IS_PENDING_ADD = "pendingAdd";
    private static final String WF_FIELD_EXCLUSIVE = "exclusiveLockedByMe";
    private static final String WF_FIELD_SUBMITTABLE = "submittable";
    private static final String WF_FIELD_INVALID = "invalid";
    private static final String WF_FIELD_ORDINAL = "ordinal";
    private Map fields = new HashMap(24);
    private File file;
    private File workingRoot;
    private APIException exception;

    WorkingFile(File file, String sandbox, File root, WorkItem viewsandboxWorkItem, Date timestamp, String userId, long ordinal) {
        this(file, sandbox, root, false, timestamp, ordinal);
        this.generateFromWorkItem(viewsandboxWorkItem, userId);
    }

    WorkingFile(File file, APIException ex, Date timestamp, long ordinal) {
        this(file, null, null, false, ex, timestamp, ordinal);
    }

    WorkingFile(File file, String sandbox, File root, boolean controlled, Date timestamp, long ordinal) {
        this(file, sandbox, root, controlled, null, timestamp, ordinal);
    }

    private WorkingFile(File file, String sandbox, File root, boolean controlled, APIException ex, Date timestamp, long ordinal) {
        this.fields.put(WF_FIELD_MEMBER_NAME, null);
        this.fields.put(WF_FIELD_SANDBOX, null);
        this.fields.put(WF_FIELD_IN_SANDBOX_DIR, Boolean.FALSE);
        this.fields.put(WF_FIELD_CONTROLLED, Boolean.FALSE);
        this.fields.put(WF_FIELD_MEMBER, Boolean.FALSE);
        this.fields.put(WF_FIELD_FORMER_MEMBER, Boolean.FALSE);
        this.fields.put(WF_FIELD_ADDED, Boolean.FALSE);
        this.fields.put(WF_FIELD_DROPPED, Boolean.FALSE);
        this.fields.put(WF_FIELD_MOVED, Boolean.FALSE);
        this.fields.put(WF_FIELD_MODIFIED, Boolean.FALSE);
        this.fields.put(WF_FIELD_OUT_OF_DATE, Boolean.FALSE);
        this.fields.put(WF_FIELD_INCOMING, Boolean.FALSE);
        this.fields.put(WF_FIELD_LOCKED_BY_ME, Boolean.FALSE);
        this.fields.put(WF_FIELD_LOCKED_BY_OTHER, Boolean.FALSE);
        this.fields.put(WF_FIELD_EXCLUSIVE_LOCKED_BY_OTHER, Boolean.FALSE);
        this.fields.put(WF_FIELD_IS_PENDING, Boolean.FALSE);
        this.fields.put(WF_FIELD_IS_PENDING_ADD, Boolean.FALSE);
        this.fields.put(WF_FIELD_EXCLUSIVE, Boolean.FALSE);
        this.fields.put(WF_FIELD_WORKING_DELTA, Boolean.FALSE);
        this.fields.put(WF_FIELD_WORKING_CPID, null);
        this.fields.put(WF_FIELD_WORKING_REV, null);
        this.fields.put(WF_FIELD_MEMBER_REV, null);
        this.fields.put(WF_FIELD_IS_SHARED, Boolean.FALSE);
        this.exception = null;
        if (timestamp == null) {
            throw new APIError("Assertion: Working File missing timestamp");
        }
        this.file = file;
        this.workingRoot = root;
        this.ordinal = ordinal;
        this.fields.put(WF_FIELD_MEMBER_NAME, file);
        this.fields.put(WF_FIELD_SANDBOX, sandbox);
        this.fields.put(WF_FIELD_IN_SANDBOX_DIR, sandbox == null ? Boolean.FALSE : Boolean.TRUE);
        this.fields.put(WF_FIELD_CONTROLLED, controlled ? Boolean.TRUE : Boolean.FALSE);
        if (ex == null) {
            if (file == null || file.isDirectory()) {
                ex = new InvalidItemException();
            }
            if (!file.exists()) {
                ex = new ItemNotFoundException();
            }
        }
        this.setAPIException(ex);
    }

    private File constructMemberFile(String sandbox, String relativePath) {
        File sandboxDir = new File(sandbox).getParentFile();
        return new File(sandboxDir, relativePath);
    }

    private void generateFromWorkItem(WorkItem wi, String userId) {
        Item item;
        APIException apix = wi.getAPIException();
        if (apix != null) {
            String exceptionName = apix.getField("exception-name").getString();
            if (apix instanceof ItemNotFoundException) {
                if (!"si.MemberNotFound".equals(exceptionName)) {
                    if ("si.NoSuchSubproject".equals(exceptionName)) {
                        this.fields.put(WF_FIELD_FORMER_MEMBER, Boolean.TRUE);
                    } else {
                        this.setAPIException(apix);
                    }
                }
                return;
            }
            this.setAPIException(apix);
            return;
        }
        if (this.getAPIException() instanceof ItemNotFoundException) {
            this.setAPIException(null);
        }
        this.fields.put(WF_FIELD_CONTROLLED, Boolean.TRUE);
        this.fields.put(WF_FIELD_IN_SANDBOX_DIR, Boolean.TRUE);
        if ("si.Sandbox".equals(wi.getModelType()) || "si.Project".equals(wi.getModelType())) {
            this.fields.put(WF_FIELD_MEMBER_NAME, this.file);
            this.fields.put(WF_FIELD_SANDBOX, this.file.getAbsolutePath());
            String type = wi.getField("type").getValueAsString();
            boolean shared = type.indexOf(WF_FIELD_IS_SHARED) != -1;
            this.fields.put(WF_FIELD_IS_SHARED, new Boolean(shared));
            return;
        }
        String name = wi.getField("name").getString();
        this.file = new File(name);
        String sandbox = wi.getField("canonicalSandbox").getString();
        String relativeMemberName = wi.getField("canonicalMember").getString();
        File memberFile = this.constructMemberFile(sandbox, relativeMemberName);
        this.fields.put(WF_FIELD_MEMBER_NAME, memberFile);
        this.fields.put(WF_FIELD_SANDBOX, sandbox);
        if ("si.FormerMember".equals(wi.getModelType())) {
            this.fields.put(WF_FIELD_FORMER_MEMBER, Boolean.TRUE);
            return;
        }
        String workingCpid = null;
        try {
            item = wi.getField("workingcpid").getItem();
            if (item != null) {
                workingCpid = item.getId();
            }
        }
        catch (NoSuchElementException nsex) {
            // empty catch block
        }
        this.fields.put(WF_FIELD_WORKING_CPID, workingCpid);
        if (!this.file.equals(memberFile)) {
            this.fields.put(WF_FIELD_MOVED, Boolean.TRUE);
        }
        String type = wi.getField("type").getString();
        if ("si.DestinedMember".equals(wi.getModelType())) {
            if ("deferred-add".equals(type)) {
                this.fields.put(WF_FIELD_ADDED, Boolean.TRUE);
                return;
            }
            if ("deferred-move-to".equals(type)) {
                return;
            }
        }
        if (type.indexOf("pending-add") != -1) {
            this.fields.put(WF_FIELD_IS_PENDING_ADD, Boolean.TRUE);
        }
        this.fields.put(WF_FIELD_SUBMITTABLE, wi.getField("deferred").getBoolean());
        this.fields.put(WF_FIELD_MEMBER, Boolean.TRUE);
        if ("si.DoomedMember".equals(wi.getModelType())) {
            this.fields.put(WF_FIELD_DROPPED, Boolean.TRUE);
        }
        try {
            List lockRecords;
            Boolean workingRevLockedByMe;
            String memberRev = null;
            item = wi.getField("memberrev").getItem();
            if (item != null) {
                memberRev = item.getId();
            }
            this.fields.put(WF_FIELD_MEMBER_REV, memberRev);
            String workingRev = null;
            item = wi.getField("workingrev").getItem();
            if (item != null) {
                workingRev = item.getId();
            }
            this.fields.put(WF_FIELD_WORKING_REV, workingRev);
            item = wi.getField("wfdelta").getItem();
            boolean wfDelta = false;
            boolean wfDeltaSizeChanged = false;
            boolean noWorkingFile = false;
            if (item != null) {
                Long currentSize;
                Boolean noWfObj;
                Boolean wfDeltaObj = item.getField("isDelta").getBoolean();
                if (wfDeltaObj != null) {
                    wfDelta = wfDeltaObj;
                }
                if ((noWfObj = item.getField("noWorkingFile").getBoolean()) != null) {
                    noWorkingFile = noWfObj;
                }
                if ((currentSize = item.getField("workingFileSize").getLong()) != null) {
                    Long cachedSize = item.getField("cachedFileSize").getLong();
                    wfDeltaSizeChanged = !currentSize.equals(cachedSize);
                }
            }
            item = wi.getField("revsyncdelta").getItem();
            boolean revSyncDelta = false;
            boolean isWorkingRevUnknown = false;
            if (item != null) {
                Boolean isWorkingRevPendingObj;
                Boolean isWorkingRevUnknownObj;
                Boolean revSyncDeltaObj = item.getField("isDelta").getBoolean();
                if (revSyncDeltaObj != null) {
                    revSyncDelta = revSyncDeltaObj;
                }
                if ((isWorkingRevUnknownObj = item.getField("isWorkingRevUnknown").getBoolean()) != null) {
                    isWorkingRevUnknown = isWorkingRevUnknownObj;
                }
                if ((isWorkingRevPendingObj = item.getField("isWorkingRevPending").getBoolean()) != null) {
                    this.fields.put(WF_FIELD_IS_PENDING, isWorkingRevPendingObj);
                }
            }
            if (wfDelta && !noWorkingFile) {
                this.fields.put(WF_FIELD_WORKING_DELTA, Boolean.TRUE);
                if (wfDeltaSizeChanged) {
                    this.markModified();
                }
            }
            if (noWorkingFile && isWorkingRevUnknown) {
                this.fields.put(WF_FIELD_INCOMING, Boolean.TRUE);
            }
            if (revSyncDelta) {
                this.fields.put(WF_FIELD_OUT_OF_DATE, Boolean.TRUE);
            }
            if ((workingRevLockedByMe = wi.getField("workingrevlockedbyme").getBoolean()) != null) {
                this.fields.put(WF_FIELD_LOCKED_BY_ME, workingRevLockedByMe);
            }
            if ((lockRecords = wi.getField("lockrecord").getList()) != null) {
                Iterator i = lockRecords.iterator();
                while (i.hasNext()) {
                    Item lockRecord = (Item)i.next();
                    Item revision = lockRecord.getField("revision").getItem();
                    Item user = lockRecord.getField("locker").getItem();
                    String lockType = lockRecord.getField("locktype").getString();
                    if (user == null || revision == null || workingRev == null || !workingRev.equals(revision.getId())) continue;
                    if (user.getId().equals(userId)) {
                        if (!"exclusive".equals(lockType)) continue;
                        this.fields.put(WF_FIELD_EXCLUSIVE, Boolean.TRUE);
                        continue;
                    }
                    this.fields.put(WF_FIELD_LOCKED_BY_OTHER, Boolean.TRUE);
                    if (!"exclusive".equals(lockType)) continue;
                    this.fields.put(WF_FIELD_EXCLUSIVE_LOCKED_BY_OTHER, Boolean.TRUE);
                }
            }
        }
        catch (NoSuchElementException nsex) {
            // empty catch block
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkingFile)) {
            return false;
        }
        WorkingFile wf = (WorkingFile)obj;
        if (this == wf) {
            return true;
        }
        if (this.file == null && wf.file != null || !this.file.equals(wf.file)) {
            return false;
        }
        if (this.fields.size() != wf.fields.size()) {
            return false;
        }
        Iterator it = this.fields.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object thisValue = this.fields.get(key);
            Object wfValue = wf.fields.get(key);
            if ((thisValue != null || wfValue == null) && (thisValue == null || thisValue.equals(wfValue))) continue;
            return false;
        }
        return true;
    }

    public boolean isInvalid() {
        return !this.valid;
    }

    void invalidate() {
        this.valid = false;
    }

    public boolean isInSandboxDir() {
        return (Boolean)this.fields.get(WF_FIELD_IN_SANDBOX_DIR);
    }

    public boolean isControlled() {
        return (Boolean)this.fields.get(WF_FIELD_CONTROLLED);
    }

    public boolean isMember() {
        return (Boolean)this.fields.get(WF_FIELD_MEMBER);
    }

    public boolean isFormerMember() {
        return (Boolean)this.fields.get(WF_FIELD_FORMER_MEMBER);
    }

    public boolean isAdded() {
        return (Boolean)this.fields.get(WF_FIELD_ADDED);
    }

    public boolean isDropped() {
        return (Boolean)this.fields.get(WF_FIELD_DROPPED);
    }

    public boolean isMoved() {
        return (Boolean)this.fields.get(WF_FIELD_MOVED);
    }

    public boolean isDeferred() {
        return this.getWorkingCpid() != null || this.isAdded() || this.isDropped() || this.isMoved();
    }

    public boolean hasWorkingDelta() {
        return (Boolean)this.fields.get(WF_FIELD_WORKING_DELTA);
    }

    void markModified() {
        this.fields.put(WF_FIELD_MODIFIED, Boolean.TRUE);
    }

    public boolean isModified() {
        return (Boolean)this.fields.get(WF_FIELD_MODIFIED);
    }

    public boolean isOutOfDate() {
        return (Boolean)this.fields.get(WF_FIELD_OUT_OF_DATE);
    }

    public boolean isIncoming() {
        return (Boolean)this.fields.get(WF_FIELD_INCOMING);
    }

    public boolean isLockedByMe() {
        return (Boolean)this.fields.get(WF_FIELD_LOCKED_BY_ME);
    }

    public boolean isLockedByOther() {
        return (Boolean)this.fields.get(WF_FIELD_LOCKED_BY_OTHER);
    }

    public boolean isExclusiveLockByOther() {
        return (Boolean)this.fields.get(WF_FIELD_EXCLUSIVE_LOCKED_BY_OTHER);
    }

    public boolean isExclusiveLockByMe() {
        return (Boolean)this.fields.get(WF_FIELD_EXCLUSIVE);
    }

    public boolean isPending() {
        return (Boolean)this.fields.get(WF_FIELD_IS_PENDING);
    }

    public boolean isShared() {
        return (Boolean)this.fields.get(WF_FIELD_IS_SHARED);
    }

    public boolean isPendingAdd() {
        return (Boolean)this.fields.get(WF_FIELD_IS_PENDING_ADD);
    }

    public File getMemberName() {
        return (File)this.fields.get(WF_FIELD_MEMBER_NAME);
    }

    public String getMemberRev() {
        return (String)this.fields.get(WF_FIELD_MEMBER_REV);
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file.getAbsolutePath();
    }

    public String getSandbox() {
        return (String)this.fields.get(WF_FIELD_SANDBOX);
    }

    public String getWorkingCpid() {
        return (String)this.fields.get(WF_FIELD_WORKING_CPID);
    }

    public String getWorkingRev() {
        return (String)this.fields.get(WF_FIELD_WORKING_REV);
    }

    public File getWorkingRoot() {
        return this.workingRoot;
    }

    public String toString() {
        return this.getName();
    }

    public String statusString() {
        String string = "Working File: " + this.getName() + "\n" + " Member Name: " + this.getMemberName() + "\n" + " Sandbox: " + this.getSandbox() + "\n" + " Working Root: " + this.getWorkingRoot() + "\n" + " Working CPID: " + this.getWorkingCpid() + "\n" + " Member Rev: " + this.getMemberRev() + "\n" + " Working Rev: " + this.getWorkingRev() + "\n" + " Invalid: " + this.isInvalid() + "\n" + " In Sandbox Dir: " + this.isInSandboxDir() + "\n" + " isControlled: " + this.isControlled() + "\n" + " member: " + this.isMember() + "\n" + " former Member: " + this.isFormerMember() + "\n" + " added: " + this.isAdded() + "\n" + " dropped: " + this.isDropped() + "\n" + " moved: " + this.isMoved() + "\n" + " has WF Delta: " + this.hasWorkingDelta() + "\n" + " modified: " + this.isModified() + "\n" + " incoming: " + this.isIncoming() + "\n" + " outOfDate: " + this.isOutOfDate() + "\n" + " locked by me: " + this.isLockedByMe() + "\n" + " locked by other: " + this.isLockedByOther() + "\n" + " deferred: " + this.isDeferred() + "\n" + " exclusive by other: " + this.isExclusiveLockByOther() + "\n" + " exclusive by me: " + this.isExclusiveLockByMe() + "\n" + " pending: " + this.isPending() + "\n" + " pending Add: " + this.isPendingAdd() + "\n" + " ordinal: " + this.getOrdinal() + "\n";
        if (this.exception != null) {
            string = string + " exception: " + this.exception.getExceptionId() + "\n";
        }
        return string;
    }

    private void setAPIException(APIException exception) {
        this.exception = exception;
        this.valid = exception == null;
    }

    public APIException getAPIException() {
        return this.exception;
    }

    public long getOrdinal() {
        return this.ordinal;
    }

    public String getContext() {
        return this.getSandbox();
    }

    public String getContext(String key) {
        return null;
    }

    public Enumeration getContextKeys() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    public String getDisplayId() {
        return null;
    }

    public String getId() {
        String id = this.getName();
        if (WorkingFileFactory.isWin32()) {
            id = id.toLowerCase();
        }
        return id;
    }

    public String getModelType() {
        return "si.WorkingFile";
    }

    public boolean contains(String id) {
        return this.fields.containsKey(id);
    }

    public Field getField(String id) {
        Comparable<Boolean> fieldValue = null;
        if (WF_FIELD_INVALID.equals(id)) {
            fieldValue = this.isInvalid() ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_ORDINAL.equals(id)) {
            fieldValue = new Long(this.ordinal);
        } else {
            if (!this.contains(id)) {
                throw new NoSuchElementException();
            }
            fieldValue = this.fields.get(id);
        }
        SimpleResponseFactory factory = SimpleResponseFactory.getResponseFactory();
        ModifiableField field = factory.createField(id);
        field.setValue(fieldValue);
        return field;
    }

    public int getFieldListSize() {
        return this.fields.size() + 2;
    }

    public Iterator getFields() {
        ArrayList<Field> itemFields = new ArrayList<Field>(this.getFieldListSize());
        Iterator ids = this.fields.keySet().iterator();
        while (ids.hasNext()) {
            itemFields.add(this.getField((String)ids.next()));
        }
        itemFields.add(this.getField(WF_FIELD_INVALID));
        itemFields.add(this.getField(WF_FIELD_ORDINAL));
        return itemFields.iterator();
    }
}

