/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.rpc;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.p2p.solanaj.core.Account;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.core.Transaction;
import org.p2p.solanaj.rpc.RpcClient;
import org.p2p.solanaj.rpc.RpcException;
import org.p2p.solanaj.rpc.types.AccountInfo;
import org.p2p.solanaj.rpc.types.Block;
import org.p2p.solanaj.rpc.types.BlockCommitment;
import org.p2p.solanaj.rpc.types.BlockProduction;
import org.p2p.solanaj.rpc.types.ClusterNode;
import org.p2p.solanaj.rpc.types.ConfirmedBlock;
import org.p2p.solanaj.rpc.types.ConfirmedSignFAddr2;
import org.p2p.solanaj.rpc.types.ConfirmedTransaction;
import org.p2p.solanaj.rpc.types.DataSize;
import org.p2p.solanaj.rpc.types.EpochInfo;
import org.p2p.solanaj.rpc.types.EpochSchedule;
import org.p2p.solanaj.rpc.types.FeeCalculatorInfo;
import org.p2p.solanaj.rpc.types.FeeRateGovernorInfo;
import org.p2p.solanaj.rpc.types.FeesInfo;
import org.p2p.solanaj.rpc.types.Filter;
import org.p2p.solanaj.rpc.types.InflationGovernor;
import org.p2p.solanaj.rpc.types.InflationRate;
import org.p2p.solanaj.rpc.types.InflationReward;
import org.p2p.solanaj.rpc.types.LargeAccount;
import org.p2p.solanaj.rpc.types.LatestBlockhash;
import org.p2p.solanaj.rpc.types.LeaderSchedule;
import org.p2p.solanaj.rpc.types.Memcmp;
import org.p2p.solanaj.rpc.types.PerformanceSample;
import org.p2p.solanaj.rpc.types.ProgramAccount;
import org.p2p.solanaj.rpc.types.RecentBlockhash;
import org.p2p.solanaj.rpc.types.RecentPrioritizationFees;
import org.p2p.solanaj.rpc.types.RpcResultTypes;
import org.p2p.solanaj.rpc.types.SignatureInformation;
import org.p2p.solanaj.rpc.types.SignatureStatuses;
import org.p2p.solanaj.rpc.types.SimulatedTransaction;
import org.p2p.solanaj.rpc.types.SnapshotSlot;
import org.p2p.solanaj.rpc.types.SolanaVersion;
import org.p2p.solanaj.rpc.types.SplTokenAccountInfo;
import org.p2p.solanaj.rpc.types.StakeActivation;
import org.p2p.solanaj.rpc.types.Supply;
import org.p2p.solanaj.rpc.types.TokenAccountInfo;
import org.p2p.solanaj.rpc.types.TokenResultObjects;
import org.p2p.solanaj.rpc.types.VoteAccounts;
import org.p2p.solanaj.rpc.types.config.BlockConfig;
import org.p2p.solanaj.rpc.types.config.Commitment;
import org.p2p.solanaj.rpc.types.config.LargestAccountConfig;
import org.p2p.solanaj.rpc.types.config.LeaderScheduleConfig;
import org.p2p.solanaj.rpc.types.config.ProgramAccountConfig;
import org.p2p.solanaj.rpc.types.config.RpcEpochConfig;
import org.p2p.solanaj.rpc.types.config.RpcSendTransactionConfig;
import org.p2p.solanaj.rpc.types.config.SignatureStatusConfig;
import org.p2p.solanaj.rpc.types.config.SimulateTransactionConfig;
import org.p2p.solanaj.rpc.types.config.VoteAccountConfig;
import org.p2p.solanaj.ws.SubscriptionWebSocketClient;
import org.p2p.solanaj.ws.listeners.NotificationEventListener;

public class RpcApi {
    private RpcClient client;

    public RpcApi(RpcClient client) {
        this.client = client;
    }

    public LatestBlockhash getLatestBlockhash() throws RpcException {
        return this.getLatestBlockhash(null);
    }

    public LatestBlockhash getLatestBlockhash(Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("getLatestBlockhash", params, LatestBlockhash.class);
    }

    @Deprecated
    public String getRecentBlockhash() throws RpcException {
        return this.getRecentBlockhash(null);
    }

    @Deprecated
    public String getRecentBlockhash(Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("getRecentBlockhash", params, RecentBlockhash.class).getValue().getBlockhash();
    }

    public String sendTransaction(Transaction transaction, Account signer, String recentBlockHash) throws RpcException {
        return this.sendTransaction(transaction, Collections.singletonList(signer), recentBlockHash);
    }

    public String sendTransaction(Transaction transaction, Account signer) throws RpcException {
        return this.sendTransaction(transaction, Collections.singletonList(signer), null);
    }

    public String sendTransaction(Transaction transaction, List<Account> signers, String recentBlockHash, RpcSendTransactionConfig rpcSendTransactionConfig) throws RpcException {
        if (recentBlockHash == null) {
            recentBlockHash = this.getLatestBlockhash().getValue().getBlockhash();
        }
        transaction.setRecentBlockHash(recentBlockHash);
        transaction.sign(signers);
        byte[] serializedTransaction = transaction.serialize();
        String base64Trx = Base64.getEncoder().encodeToString(serializedTransaction);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(base64Trx);
        params.add(rpcSendTransactionConfig);
        return this.client.call("sendTransaction", params, String.class);
    }

    public String sendTransaction(Transaction transaction, List<Account> signers, String recentBlockHash) throws RpcException {
        return this.sendTransaction(transaction, signers, recentBlockHash, new RpcSendTransactionConfig());
    }

    public void sendAndConfirmTransaction(Transaction transaction, List<Account> signers, NotificationEventListener listener) throws RpcException {
        String signature = this.sendTransaction(transaction, signers, null);
        SubscriptionWebSocketClient subClient = SubscriptionWebSocketClient.getInstance(this.client.getEndpoint());
        subClient.signatureSubscribe(signature, listener);
    }

    public long getBalance(PublicKey account) throws RpcException {
        return this.getBalance(account, null);
    }

    public long getBalance(PublicKey account, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(account.toString());
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("getBalance", params, RpcResultTypes.ValueLong.class).getValue();
    }

    public ConfirmedTransaction getTransaction(String signature) throws RpcException {
        return this.getTransaction(signature, null);
    }

    public ConfirmedTransaction getTransaction(String signature, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(signature);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (commitment != null) {
            parameterMap.put("commitment", (Object)commitment);
        }
        parameterMap.put("maxSupportedTransactionVersion", 0);
        params.add(parameterMap);
        return this.client.call("getTransaction", params, ConfirmedTransaction.class);
    }

    public List<SignatureInformation> getConfirmedSignaturesForAddress2(PublicKey account, int limit) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(account.toString());
        params.add(new ConfirmedSignFAddr2(limit, Commitment.CONFIRMED));
        List rawResult = this.client.call("getConfirmedSignaturesForAddress2", params, List.class);
        ArrayList<SignatureInformation> result = new ArrayList<SignatureInformation>();
        for (AbstractMap item : rawResult) {
            result.add(new SignatureInformation(item));
        }
        return result;
    }

    public List<SignatureInformation> getSignaturesForAddress(PublicKey account, int limit, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(account.toString());
        params.add(new ConfirmedSignFAddr2(limit, commitment));
        List rawResult = this.client.call("getSignaturesForAddress", params, List.class);
        ArrayList<SignatureInformation> result = new ArrayList<SignatureInformation>();
        for (AbstractMap item : rawResult) {
            result.add(new SignatureInformation(item));
        }
        return result;
    }

    public List<ProgramAccount> getProgramAccounts(PublicKey account, long offset, String bytes) throws RpcException {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new Filter(new Memcmp(offset, bytes)));
        ProgramAccountConfig programAccountConfig = new ProgramAccountConfig(filters);
        return this.getProgramAccounts(account, programAccountConfig);
    }

    public List<ProgramAccount> getProgramAccountsBase64(PublicKey account, long offset, String bytes) throws RpcException {
        ArrayList<Object> filters = new ArrayList<Object>();
        Memcmp memcmp = new Memcmp(offset, bytes);
        filters.add(new Filter(memcmp));
        ProgramAccountConfig programAccountConfig = new ProgramAccountConfig(RpcSendTransactionConfig.Encoding.base64);
        programAccountConfig.setFilters(filters);
        return this.getProgramAccounts(account, programAccountConfig);
    }

    public List<ProgramAccount> getProgramAccounts(PublicKey account) throws RpcException {
        return this.getProgramAccounts(account, new ProgramAccountConfig(RpcSendTransactionConfig.Encoding.base64));
    }

    public List<ProgramAccount> getProgramAccounts(PublicKey account, ProgramAccountConfig programAccountConfig) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(account.toString());
        if (programAccountConfig != null) {
            params.add(programAccountConfig);
        }
        List rawResult = this.client.call("getProgramAccounts", params, List.class);
        ArrayList<ProgramAccount> result = new ArrayList<ProgramAccount>();
        for (AbstractMap item : rawResult) {
            result.add(new ProgramAccount(item));
        }
        return result;
    }

    public List<ProgramAccount> getProgramAccounts(PublicKey account, List<Memcmp> memcmpList, int dataSize) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(account.toString());
        ArrayList<Object> filters = new ArrayList<Object>();
        memcmpList.forEach(memcmp -> filters.add(new Filter((Memcmp)memcmp)));
        filters.add(new DataSize(dataSize));
        ProgramAccountConfig programAccountConfig = new ProgramAccountConfig(filters);
        programAccountConfig.setEncoding(RpcSendTransactionConfig.Encoding.base64);
        params.add(programAccountConfig);
        List rawResult = this.client.call("getProgramAccounts", params, List.class);
        ArrayList<ProgramAccount> result = new ArrayList<ProgramAccount>();
        for (AbstractMap item : rawResult) {
            result.add(new ProgramAccount(item));
        }
        return result;
    }

    public List<ProgramAccount> getProgramAccounts(PublicKey account, List<Memcmp> memcmpList) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(account.toString());
        ArrayList<Object> filters = new ArrayList<Object>();
        memcmpList.forEach(memcmp -> filters.add(new Filter((Memcmp)memcmp)));
        ProgramAccountConfig programAccountConfig = new ProgramAccountConfig(filters);
        programAccountConfig.setEncoding(RpcSendTransactionConfig.Encoding.base64);
        params.add(programAccountConfig);
        List rawResult = this.client.call("getProgramAccounts", params, List.class);
        ArrayList<ProgramAccount> result = new ArrayList<ProgramAccount>();
        for (AbstractMap item : rawResult) {
            result.add(new ProgramAccount(item));
        }
        return result;
    }

    public AccountInfo getAccountInfo(PublicKey account) throws RpcException {
        return this.getAccountInfo(account, new HashMap<String, Object>());
    }

    public AccountInfo getAccountInfo(PublicKey account, Map<String, Object> additionalParams) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("encoding", additionalParams.getOrDefault("encoding", "base64"));
        if (additionalParams.containsKey("commitment")) {
            Commitment commitment = (Commitment)((Object)additionalParams.get("commitment"));
            parameterMap.put("commitment", commitment.getValue());
        }
        if (additionalParams.containsKey("dataSlice")) {
            parameterMap.put("dataSlice", additionalParams.get("dataSlice"));
        }
        if (additionalParams.containsKey("minContextSlot")) {
            parameterMap.put("minContextSlot", additionalParams.get("minContextSlot"));
        }
        params.add(account.toString());
        params.add(parameterMap);
        return this.client.call("getAccountInfo", params, AccountInfo.class);
    }

    public SplTokenAccountInfo getSplTokenAccountInfo(PublicKey account) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("encoding", "jsonParsed");
        params.add(account.toString());
        params.add(parameterMap);
        return this.client.call("getAccountInfo", params, SplTokenAccountInfo.class);
    }

    public long getMinimumBalanceForRentExemption(long dataLength) throws RpcException {
        return this.getMinimumBalanceForRentExemption(dataLength, null);
    }

    public long getMinimumBalanceForRentExemption(long dataLength, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(dataLength);
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("getMinimumBalanceForRentExemption", params, Long.class);
    }

    public long getBlockTime(long block) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(block);
        return this.client.call("getBlockTime", params, Long.class);
    }

    public long getBlockHeight() throws RpcException {
        return this.getBlockHeight(null);
    }

    public long getBlockHeight(Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("getBlockHeight", params, Long.class);
    }

    public BlockProduction getBlockProduction() throws RpcException {
        return this.getBlockProduction(new HashMap<String, Object>());
    }

    public BlockProduction getBlockProduction(Map<String, Object> optionalParams) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (optionalParams.containsKey("commitment")) {
            Commitment commitment = (Commitment)((Object)optionalParams.get("commitment"));
            parameterMap.put("commitment", commitment.getValue());
        }
        params.add(parameterMap);
        return this.client.call("getBlockProduction", params, BlockProduction.class);
    }

    public Long minimumLedgerSlot() throws RpcException {
        return this.client.call("minimumLedgerSlot", new ArrayList<Object>(), Long.class);
    }

    public SolanaVersion getVersion() throws RpcException {
        return this.client.call("getVersion", new ArrayList<Object>(), SolanaVersion.class);
    }

    public String requestAirdrop(PublicKey address, long lamports) throws RpcException {
        return this.requestAirdrop(address, lamports, null);
    }

    public String requestAirdrop(PublicKey address, long lamports, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(address.toString());
        params.add(lamports);
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("requestAirdrop", params, String.class);
    }

    public BlockCommitment getBlockCommitment(long block) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(block);
        return this.client.call("getBlockCommitment", params, BlockCommitment.class);
    }

    @Deprecated
    public FeeCalculatorInfo getFeeCalculatorForBlockhash(String blockhash) throws RpcException {
        return this.getFeeCalculatorForBlockhash(blockhash, null);
    }

    @Deprecated
    public FeeCalculatorInfo getFeeCalculatorForBlockhash(String blockhash, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(blockhash);
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("getFeeCalculatorForBlockhash", params, FeeCalculatorInfo.class);
    }

    @Deprecated
    public FeeRateGovernorInfo getFeeRateGovernor() throws RpcException {
        return this.client.call("getFeeRateGovernor", new ArrayList<Object>(), FeeRateGovernorInfo.class);
    }

    public Long getFeeForMessage(String message) throws RpcException {
        return this.getFeeForMessage(message, null);
    }

    public Long getFeeForMessage(String message, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(message);
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (commitment != null) {
            configMap.put("commitment", commitment.getValue());
        }
        params.add(configMap);
        Long feeValue = this.client.call("getFeeForMessage", params, RpcResultTypes.ValueLong.class).getValue();
        if (feeValue == null) {
            return 0L;
        }
        return feeValue;
    }

    public List<RecentPrioritizationFees> getRecentPrioritizationFees() throws RpcException {
        return this.getRecentPrioritizationFees(null);
    }

    public List<RecentPrioritizationFees> getRecentPrioritizationFees(List<PublicKey> addresses) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (addresses != null) {
            params.add(addresses.stream().map(PublicKey::toBase58).toList());
        }
        List rawResult = this.client.call("getRecentPrioritizationFees", params, List.class);
        ArrayList<RecentPrioritizationFees> result = new ArrayList<RecentPrioritizationFees>();
        for (Map item : rawResult) {
            result.add(new RecentPrioritizationFees(item));
        }
        return result;
    }

    public Long getStakeMinimumDelegation() throws RpcException {
        return this.getStakeMinimumDelegation(null);
    }

    public Long getStakeMinimumDelegation(Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (commitment != null) {
            HashMap<String, String> configMap = new HashMap<String, String>();
            configMap.put("commitment", commitment.getValue());
            params.add(configMap);
        }
        return this.client.call("getStakeMinimumDelegation", params, RpcResultTypes.ValueLong.class).getValue();
    }

    @Deprecated
    public FeesInfo getFees() throws RpcException {
        return this.getFees(null);
    }

    @Deprecated
    public FeesInfo getFees(Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("getFees", params, FeesInfo.class);
    }

    public long getTransactionCount() throws RpcException {
        return this.getTransactionCount(null);
    }

    public long getTransactionCount(Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("getTransactionCount", params, Long.class);
    }

    public long getMaxRetransmitSlot() throws RpcException {
        return this.client.call("getMaxRetransmitSlot", new ArrayList<Object>(), Long.class);
    }

    public SimulatedTransaction simulateTransaction(String transaction, List<PublicKey> addresses) throws RpcException {
        SimulateTransactionConfig simulateTransactionConfig = new SimulateTransactionConfig(RpcSendTransactionConfig.Encoding.base64);
        simulateTransactionConfig.setAccounts(Map.of("encoding", RpcSendTransactionConfig.Encoding.base64, "addresses", addresses.stream().map(PublicKey::toBase58).collect(Collectors.toList())));
        simulateTransactionConfig.setReplaceRecentBlockhash(true);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(transaction);
        params.add(simulateTransactionConfig);
        SimulatedTransaction simulatedTransaction = this.client.call("simulateTransaction", params, SimulatedTransaction.class);
        return simulatedTransaction;
    }

    public List<ClusterNode> getClusterNodes() throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        List rawResult = this.client.call("getClusterNodes", params, List.class);
        ArrayList<ClusterNode> result = new ArrayList<ClusterNode>();
        for (AbstractMap item : rawResult) {
            result.add(new ClusterNode(item));
        }
        return result;
    }

    @Deprecated
    public ConfirmedBlock getConfirmedBlock(int slot) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(slot);
        params.add(new BlockConfig());
        return this.client.call("getConfirmedBlock", params, ConfirmedBlock.class);
    }

    public Block getBlock(int slot) throws RpcException {
        return this.getBlock(slot, null);
    }

    public Block getBlock(int slot, Map<String, Object> optionalParams) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(slot);
        if (optionalParams != null) {
            BlockConfig blockConfig = new BlockConfig();
            if (optionalParams.containsKey("commitment")) {
                Commitment commitment = (Commitment)((Object)optionalParams.get("commitment"));
                blockConfig.setCommitment(commitment.getValue());
            }
            if (optionalParams.containsKey("maxSupportedTransactionVersion")) {
                blockConfig.setMaxSupportedTransactionVersion((Integer)optionalParams.get("maxSupportedTransactionVersion"));
            }
            params.add(blockConfig);
        }
        return this.client.call("getBlock", params, Block.class);
    }

    public SnapshotSlot getHighestSnapshotSlot() throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        return this.client.call("getHighestSnapshotSlot", params, SnapshotSlot.class);
    }

    public EpochInfo getEpochInfo() throws RpcException {
        return this.getEpochInfo(null);
    }

    public EpochInfo getEpochInfo(Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("getEpochInfo", params, EpochInfo.class);
    }

    public EpochSchedule getEpochSchedule() throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        return this.client.call("getEpochSchedule", params, EpochSchedule.class);
    }

    public PublicKey getTokenAccountsByOwner(PublicKey owner, PublicKey tokenMint) throws RpcException {
        PublicKey tokenAccountKey;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(owner.toBase58());
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("mint", tokenMint.toBase58());
        params.add(parameterMap);
        params.add(Map.of("encoding", "jsonParsed"));
        Map rawResult = this.client.call("getTokenAccountsByOwner", params, Map.class);
        try {
            String base58 = (String)((Map)((List)rawResult.get("value")).get(0)).get("pubkey");
            tokenAccountKey = new PublicKey(base58);
        }
        catch (Exception ex) {
            throw new RpcException("unable to get token account by owner");
        }
        return tokenAccountKey;
    }

    public InflationRate getInflationRate() throws RpcException {
        return this.client.call("getInflationRate", new ArrayList<Object>(), InflationRate.class);
    }

    public InflationGovernor getInflationGovernor() throws RpcException {
        return this.getInflationGovernor(null);
    }

    public InflationGovernor getInflationGovernor(Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("getInflationGovernor", params, InflationGovernor.class);
    }

    public List<InflationReward> getInflationReward(List<PublicKey> addresses) throws RpcException {
        return this.getInflationReward(addresses, null, null);
    }

    public List<InflationReward> getInflationReward(List<PublicKey> addresses, Long epoch, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(addresses.stream().map(PublicKey::toString).collect(Collectors.toList()));
        RpcEpochConfig rpcEpochConfig = new RpcEpochConfig();
        if (epoch != null) {
            rpcEpochConfig.setEpoch(epoch);
        }
        if (commitment != null) {
            rpcEpochConfig.setCommitment(commitment.getValue());
        }
        params.add(rpcEpochConfig);
        List rawResult = this.client.call("getInflationReward", params, List.class);
        ArrayList<InflationReward> result = new ArrayList<InflationReward>();
        for (AbstractMap item : rawResult) {
            if (item == null) continue;
            result.add(new InflationReward(item));
        }
        return result;
    }

    public long getSlot() throws RpcException {
        return this.getSlot(null);
    }

    public long getSlot(Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("getSlot", params, Long.class);
    }

    public PublicKey getSlotLeader() throws RpcException {
        return this.getSlotLeader(null);
    }

    public PublicKey getSlotLeader(Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return new PublicKey(this.client.call("getSlotLeader", params, String.class));
    }

    public List<PublicKey> getSlotLeaders(long startSlot, long limit) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(startSlot);
        params.add(limit);
        List rawResult = this.client.call("getSlotLeaders", params, List.class);
        ArrayList<PublicKey> result = new ArrayList<PublicKey>();
        for (String item : rawResult) {
            result.add(new PublicKey(item));
        }
        return result;
    }

    @Deprecated
    public long getSnapshotSlot() throws RpcException {
        return this.client.call("getSnapshotSlot", new ArrayList<Object>(), Long.class);
    }

    public long getMaxShredInsertSlot() throws RpcException {
        return this.client.call("getMaxShredInsertSlot", new ArrayList<Object>(), Long.class);
    }

    public PublicKey getIdentity() throws RpcException {
        PublicKey identity;
        Map rawResult = this.client.call("getIdentity", new ArrayList<Object>(), Map.class);
        try {
            String base58 = (String)rawResult.get("identity");
            identity = new PublicKey(base58);
        }
        catch (Exception ex) {
            throw new RpcException("unable to get identity");
        }
        return identity;
    }

    public Supply getSupply() throws RpcException {
        return this.getSupply(null);
    }

    public Supply getSupply(Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        return this.client.call("getSupply", params, Supply.class);
    }

    public long getFirstAvailableBlock() throws RpcException {
        return this.client.call("getFirstAvailableBlock", new ArrayList<Object>(), Long.class);
    }

    public String getGenesisHash() throws RpcException {
        return this.client.call("getGenesisHash", new ArrayList<Object>(), String.class);
    }

    @Deprecated
    public List<Double> getConfirmedBlocks(Integer start, Integer end) throws RpcException {
        List<Object> params = end == null ? Arrays.asList(start) : Arrays.asList(start, end);
        return this.client.call("getConfirmedBlocks", params, List.class);
    }

    @Deprecated
    public List<Double> getConfirmedBlocks(Integer start) throws RpcException {
        return this.getConfirmedBlocks(start, null);
    }

    public TokenResultObjects.TokenAmountInfo getTokenAccountBalance(PublicKey tokenAccount) throws RpcException {
        return this.getTokenAccountBalance(tokenAccount, null);
    }

    public TokenResultObjects.TokenAmountInfo getTokenAccountBalance(PublicKey tokenAccount, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(tokenAccount.toString());
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        Map rawResult = this.client.call("getTokenAccountBalance", params, Map.class);
        return new TokenResultObjects.TokenAmountInfo((AbstractMap)rawResult.get("value"));
    }

    public TokenResultObjects.TokenAmountInfo getTokenSupply(PublicKey tokenMint) throws RpcException {
        return this.getTokenSupply(tokenMint, null);
    }

    public TokenResultObjects.TokenAmountInfo getTokenSupply(PublicKey tokenMint, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(tokenMint.toString());
        if (null != commitment) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        Map rawResult = this.client.call("getTokenSupply", params, Map.class);
        return new TokenResultObjects.TokenAmountInfo((AbstractMap)rawResult.get("value"));
    }

    public List<TokenResultObjects.TokenAccount> getTokenLargestAccounts(PublicKey tokenMint) throws RpcException {
        return this.getTokenLargestAccounts(tokenMint, null);
    }

    public List<TokenResultObjects.TokenAccount> getTokenLargestAccounts(PublicKey tokenMint, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(tokenMint.toString());
        if (null != commitment) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        Map rawResult = this.client.call("getTokenLargestAccounts", params, Map.class);
        ArrayList<TokenResultObjects.TokenAccount> result = new ArrayList<TokenResultObjects.TokenAccount>();
        for (AbstractMap item : (List)rawResult.get("value")) {
            result.add(new TokenResultObjects.TokenAccount(item));
        }
        return result;
    }

    public TokenAccountInfo getTokenAccountsByOwner(PublicKey accountOwner, Map<String, Object> requiredParams, Map<String, Object> optionalParams) throws RpcException {
        return this.getTokenAccount(accountOwner, requiredParams, optionalParams, "getTokenAccountsByOwner");
    }

    public TokenAccountInfo getTokenAccountsByDelegate(PublicKey accountDelegate, Map<String, Object> requiredParams, Map<String, Object> optionalParams) throws RpcException {
        return this.getTokenAccount(accountDelegate, requiredParams, optionalParams, "getTokenAccountsByDelegate");
    }

    private TokenAccountInfo getTokenAccount(PublicKey account, Map<String, Object> requiredParams, Map<String, Object> optionalParams, String method) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(account.toString());
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (requiredParams.containsKey("mint")) {
            parameterMap.put("mint", requiredParams.get("mint").toString());
        } else if (requiredParams.containsKey("programId")) {
            parameterMap.put("programId", requiredParams.get("programId").toString());
        } else {
            throw new RpcException("mint or programId are mandatory parameters");
        }
        params.add(parameterMap);
        if (null != optionalParams) {
            parameterMap = new HashMap();
            parameterMap.put("encoding", optionalParams.getOrDefault("encoding", "jsonParsed"));
            if (optionalParams.containsKey("commitment")) {
                Commitment commitment = (Commitment)((Object)optionalParams.get("commitment"));
                parameterMap.put("commitment", commitment.getValue());
            }
            if (optionalParams.containsKey("dataSlice")) {
                parameterMap.put("dataSlice", optionalParams.get("dataSlice"));
            }
            params.add(parameterMap);
        }
        return this.client.call(method, params, TokenAccountInfo.class);
    }

    public VoteAccounts getVoteAccounts() throws RpcException {
        return this.getVoteAccounts(null, null);
    }

    public VoteAccounts getVoteAccounts(PublicKey votePubkey, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        VoteAccountConfig voteAccountConfig = new VoteAccountConfig();
        if (votePubkey != null) {
            voteAccountConfig.setVotePubkey(votePubkey.toBase58());
        }
        if (commitment != null) {
            voteAccountConfig.setCommitment(commitment.getValue());
        }
        params.add(voteAccountConfig);
        return this.client.call("getVoteAccounts", params, VoteAccounts.class);
    }

    @Deprecated
    public StakeActivation getStakeActivation(PublicKey publicKey) throws RpcException {
        return this.getStakeActivation(publicKey, null, null);
    }

    @Deprecated
    public StakeActivation getStakeActivation(PublicKey publicKey, Long epoch, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(publicKey.toBase58());
        RpcEpochConfig rpcEpochConfig = new RpcEpochConfig();
        if (null != epoch) {
            rpcEpochConfig.setEpoch(epoch);
        }
        if (null != commitment) {
            rpcEpochConfig.setCommitment(commitment.getValue());
        }
        params.add(rpcEpochConfig);
        return this.client.call("getStakeActivation", params, StakeActivation.class);
    }

    public SignatureStatuses getSignatureStatuses(List<String> signatures, boolean searchTransactionHistory) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(signatures);
        params.add(new SignatureStatusConfig(searchTransactionHistory));
        return this.client.call("getSignatureStatuses", params, SignatureStatuses.class);
    }

    public List<PerformanceSample> getRecentPerformanceSamples() throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        List rawResult = this.client.call("getRecentPerformanceSamples", params, List.class);
        ArrayList<PerformanceSample> result = new ArrayList<PerformanceSample>();
        for (AbstractMap item : rawResult) {
            result.add(new PerformanceSample(item));
        }
        return result;
    }

    public List<PerformanceSample> getRecentPerformanceSamples(int limit) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(limit);
        List rawResult = this.client.call("getRecentPerformanceSamples", params, List.class);
        ArrayList<PerformanceSample> result = new ArrayList<PerformanceSample>();
        for (AbstractMap item : rawResult) {
            result.add(new PerformanceSample(item));
        }
        return result;
    }

    public boolean getHealth() throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        String result = this.client.call("getHealth", params, String.class);
        return result.equals("ok");
    }

    public List<LargeAccount> getLargestAccounts() throws RpcException {
        return this.getLargestAccounts(null, null);
    }

    public List<LargeAccount> getLargestAccounts(String filter, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        LargestAccountConfig largestAccountConfig = new LargestAccountConfig();
        if (null != filter) {
            largestAccountConfig.setFilter(filter);
        }
        if (null != commitment) {
            largestAccountConfig.setCommitment(commitment.getValue());
        }
        params.add(largestAccountConfig);
        Map rawResult = this.client.call("getLargestAccounts", params, Map.class);
        ArrayList<LargeAccount> result = new ArrayList<LargeAccount>();
        for (AbstractMap item : (List)rawResult.get("value")) {
            result.add(new LargeAccount(item));
        }
        return result;
    }

    public List<LeaderSchedule> getLeaderSchedule() throws RpcException {
        return this.getLeaderSchedule(null, null, null);
    }

    public List<LeaderSchedule> getLeaderSchedule(Long epoch, String identity, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (null != epoch) {
            params.add(epoch);
        }
        LeaderScheduleConfig leaderScheduleConfig = new LeaderScheduleConfig();
        if (null != identity) {
            leaderScheduleConfig.setIdentity(identity);
        }
        if (null != commitment) {
            leaderScheduleConfig.setCommitment(commitment.getValue());
        }
        params.add(leaderScheduleConfig);
        Map rawResult = this.client.call("getLeaderSchedule", params, Map.class);
        ArrayList<LeaderSchedule> result = new ArrayList<LeaderSchedule>();
        rawResult.forEach((key, value) -> result.add(new LeaderSchedule((String)key, (List)value)));
        return result;
    }

    public List<AccountInfo.Value> getMultipleAccounts(List<PublicKey> publicKeys) throws RpcException {
        return this.getMultipleAccounts(publicKeys, new HashMap<String, Object>());
    }

    public List<AccountInfo.Value> getMultipleAccounts(List<PublicKey> publicKeys, Map<String, Object> additionalParams) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(publicKeys.stream().map(PublicKey::toBase58).collect(Collectors.toList()));
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("encoding", additionalParams.getOrDefault("encoding", "base64"));
        if (additionalParams.containsKey("commitment")) {
            Commitment commitment = (Commitment)((Object)additionalParams.get("commitment"));
            parameterMap.put("commitment", commitment.getValue());
        }
        if (additionalParams.containsKey("dataSlice")) {
            parameterMap.put("dataSlice", additionalParams.get("dataSlice"));
        }
        params.add(parameterMap);
        Map rawResult = this.client.call("getMultipleAccounts", params, Map.class);
        ArrayList<AccountInfo.Value> result = new ArrayList<AccountInfo.Value>();
        for (AbstractMap item : (List)rawResult.get("value")) {
            if (item == null) continue;
            result.add(new AccountInfo.Value(item));
        }
        return result;
    }

    public Map<PublicKey, Optional<AccountInfo.Value>> getMultipleAccountsMap(List<PublicKey> publicKeys) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        HashMap<PublicKey, Optional<AccountInfo.Value>> result = new HashMap<PublicKey, Optional<AccountInfo.Value>>();
        params.add(publicKeys.stream().map(PublicKey::toBase58).collect(Collectors.toList()));
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("encoding", "base64");
        params.add(parameterMap);
        Map rawResult = this.client.call("getMultipleAccounts", params, Map.class);
        List resultList = (List)rawResult.get("value");
        for (int i = 0; i < resultList.size(); ++i) {
            if (resultList.get(i) == null) {
                result.put(publicKeys.get(i), Optional.empty());
                continue;
            }
            result.put(publicKeys.get(i), Optional.of(new AccountInfo.Value((AbstractMap)resultList.get(i))));
        }
        return result;
    }

    public boolean isBlockhashValid(String blockHash) throws RpcException {
        return this.isBlockhashValid(blockHash, null, null);
    }

    public boolean isBlockhashValid(String blockHash, Commitment commitment, Long minContextSlot) throws RpcException {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (commitment != null) {
            parameterMap.put("commitment", (Object)commitment);
        }
        if (minContextSlot != null) {
            parameterMap.put("minContextSlot", minContextSlot);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(blockHash);
        params.add(parameterMap);
        Map call = this.client.call("isBlockhashValid", params, Map.class);
        Boolean result = (Boolean)call.get("value");
        return result;
    }

    public List<Long> getBlocks(long startSlot, long endSlot) throws RpcException {
        return this.getBlocks(startSlot, endSlot, null);
    }

    public List<Long> getBlocks(long startSlot, long endSlot, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(startSlot);
        params.add(endSlot);
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        List result = this.client.call("getBlocks", params, List.class);
        return result.stream().map(Double::longValue).collect(Collectors.toList());
    }

    public List<Long> getBlocksWithLimit(long startSlot, long limit) throws RpcException {
        return this.getBlocksWithLimit(startSlot, limit, null);
    }

    public List<Long> getBlocksWithLimit(long startSlot, long limit, Commitment commitment) throws RpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(startSlot);
        params.add(limit);
        if (commitment != null) {
            params.add(Map.of("commitment", commitment.getValue()));
        }
        List result = this.client.call("getBlocksWithLimit", params, List.class);
        return result.stream().map(Double::longValue).collect(Collectors.toList());
    }
}

