/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.utils.bip32.wallet;

import org.p2p.solanaj.utils.bip32.wallet.DerivableType;
import org.p2p.solanaj.utils.bip32.wallet.HdAddress;
import org.p2p.solanaj.utils.bip32.wallet.HdKeyGenerator;
import org.p2p.solanaj.utils.bip32.wallet.SolanaCoin;

public class SolanaBip44 {
    private final HdKeyGenerator hdKeyGenerator = new HdKeyGenerator();
    private final SolanaCoin solanaCoin = new SolanaCoin();
    private final long PURPOSE = this.solanaCoin.getPurpose();
    private final long TYPE = this.solanaCoin.getCoinType();
    private final long ACCOUNT;
    private final int CHANGE;

    public SolanaBip44() {
        this.ACCOUNT = 0L;
        this.CHANGE = 0;
    }

    public byte[] getPrivateKeyFromSeed(byte[] seed, DerivableType derivableType) {
        switch (derivableType) {
            case BIP44: {
                return this.getPrivateKeyFromBip44Seed(seed);
            }
            case BIP44CHANGE: {
                return this.getPrivateKeyFromBip44SeedWithChange(seed);
            }
        }
        throw new RuntimeException("DerivableType not supported");
    }

    private byte[] getPrivateKeyFromBip44SeedWithChange(byte[] seed) {
        HdAddress masterAddress = this.hdKeyGenerator.getAddressFromSeed(seed, this.solanaCoin);
        HdAddress purposeAddress = this.hdKeyGenerator.getAddress(masterAddress, this.PURPOSE, this.solanaCoin.getAlwaysHardened());
        HdAddress coinTypeAddress = this.hdKeyGenerator.getAddress(purposeAddress, this.TYPE, this.solanaCoin.getAlwaysHardened());
        HdAddress accountAddress = this.hdKeyGenerator.getAddress(coinTypeAddress, this.ACCOUNT, this.solanaCoin.getAlwaysHardened());
        HdAddress changeAddress = this.hdKeyGenerator.getAddress(accountAddress, this.CHANGE, this.solanaCoin.getAlwaysHardened());
        return changeAddress.getPrivateKey().getPrivateKey();
    }

    private byte[] getPrivateKeyFromBip44Seed(byte[] seed) {
        HdAddress masterAddress = this.hdKeyGenerator.getAddressFromSeed(seed, this.solanaCoin);
        HdAddress purposeAddress = this.hdKeyGenerator.getAddress(masterAddress, this.PURPOSE, this.solanaCoin.getAlwaysHardened());
        HdAddress coinTypeAddress = this.hdKeyGenerator.getAddress(purposeAddress, this.TYPE, this.solanaCoin.getAlwaysHardened());
        HdAddress accountAddress = this.hdKeyGenerator.getAddress(coinTypeAddress, this.ACCOUNT, this.solanaCoin.getAlwaysHardened());
        return accountAddress.getPrivateKey().getPrivateKey();
    }
}

