/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.ws;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.exceptions.IncompleteHandshakeException;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.handshake.ServerHandshake;
import org.p2p.solanaj.rpc.types.RpcNotificationResult;
import org.p2p.solanaj.rpc.types.RpcRequest;
import org.p2p.solanaj.rpc.types.RpcResponse;
import org.p2p.solanaj.rpc.types.config.Commitment;
import org.p2p.solanaj.ws.SignatureNotification;
import org.p2p.solanaj.ws.listeners.NotificationEventListener;

public class SubscriptionWebSocketClient
extends WebSocketClient {
    private static final Logger LOGGER = Logger.getLogger(SubscriptionWebSocketClient.class.getName());
    private static final int MAX_RECONNECT_DELAY = 30000;
    private static final int INITIAL_RECONNECT_DELAY = 1000;
    private static final int HEARTBEAT_INTERVAL = 30;
    private final Map<String, SubscriptionParams> subscriptions = new ConcurrentHashMap<String, SubscriptionParams>();
    private final Map<String, Long> subscriptionIds = new ConcurrentHashMap<String, Long>();
    private final Map<Long, NotificationEventListener> subscriptionListeners = new ConcurrentHashMap<Long, NotificationEventListener>();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final CountDownLatch connectLatch = new CountDownLatch(1);
    private int reconnectDelay = 1000;
    private final Moshi moshi = new Moshi.Builder().build();
    private final Map<String, SubscriptionParams> activeSubscriptions = new ConcurrentHashMap<String, SubscriptionParams>();
    private final Lock subscriptionLock = new ReentrantLock();
    private final Lock listenerLock = new ReentrantLock();

    public static SubscriptionWebSocketClient getExactPathInstance(String endpoint) {
        try {
            URI serverURI = new URI(endpoint);
            SubscriptionWebSocketClient instance = new SubscriptionWebSocketClient(serverURI);
            if (!instance.isOpen()) {
                instance.connect();
            }
            return instance;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint URI", e);
        }
    }

    public static SubscriptionWebSocketClient getInstance(String endpoint) {
        try {
            URI endpointURI = new URI(endpoint);
            String scheme = "https".equals(endpointURI.getScheme()) ? "wss" : "ws";
            URI serverURI = new URI(scheme + "://" + endpointURI.getHost());
            SubscriptionWebSocketClient instance = new SubscriptionWebSocketClient(serverURI);
            instance.connect();
            return instance;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint URI", e);
        }
    }

    public SubscriptionWebSocketClient(URI serverURI) {
        super(serverURI);
    }

    public void accountSubscribe(String key, NotificationEventListener listener, Commitment commitment, String encoding) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(Map.of("encoding", encoding, "commitment", commitment.getValue()));
        RpcRequest rpcRequest = new RpcRequest("accountSubscribe", params);
        this.addSubscription(rpcRequest, listener);
    }

    public void accountSubscribe(String key, NotificationEventListener listener, Commitment commitment) {
        this.accountSubscribe(key, listener, commitment, "jsonParsed");
    }

    public void accountSubscribe(String key, NotificationEventListener listener) {
        this.accountSubscribe(key, listener, Commitment.FINALIZED, "jsonParsed");
    }

    public void signatureSubscribe(String signature, NotificationEventListener listener) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(signature);
        RpcRequest rpcRequest = new RpcRequest("signatureSubscribe", params);
        this.addSubscription(rpcRequest, listener);
    }

    public void logsSubscribe(String mention, NotificationEventListener listener) {
        this.logsSubscribe(List.of(mention), listener);
    }

    public void logsSubscribe(List<String> mentions, NotificationEventListener listener) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Map.of("mentions", mentions));
        params.add(Map.of("commitment", "finalized"));
        RpcRequest rpcRequest = new RpcRequest("logsSubscribe", params);
        this.addSubscription(rpcRequest, listener);
    }

    public void blockSubscribe(NotificationEventListener listener, Commitment commitment, String encoding) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Map.of("encoding", encoding, "commitment", commitment.getValue()));
        RpcRequest rpcRequest = new RpcRequest("blockSubscribe", params);
        this.addSubscription(rpcRequest, listener);
    }

    public void blockSubscribe(NotificationEventListener listener, Commitment commitment) {
        this.blockSubscribe(listener, commitment, "json");
    }

    public void blockSubscribe(NotificationEventListener listener) {
        this.blockSubscribe(listener, Commitment.FINALIZED, "json");
    }

    public void blockUnsubscribe(String subscriptionId) {
        this.unsubscribe("blockUnsubscribe", subscriptionId);
    }

    public void programSubscribe(String programId, NotificationEventListener listener, Commitment commitment, String encoding) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(programId);
        params.add(Map.of("encoding", encoding, "commitment", commitment.getValue()));
        RpcRequest rpcRequest = new RpcRequest("programSubscribe", params);
        this.addSubscription(rpcRequest, listener);
    }

    public void programSubscribe(String programId, NotificationEventListener listener, Commitment commitment) {
        this.programSubscribe(programId, listener, commitment, "base64");
    }

    public void programSubscribe(String programId, NotificationEventListener listener) {
        this.programSubscribe(programId, listener, Commitment.FINALIZED, "base64");
    }

    public void programUnsubscribe(String subscriptionId) {
        this.unsubscribe("programUnsubscribe", subscriptionId);
    }

    public void rootSubscribe(NotificationEventListener listener) {
        RpcRequest rpcRequest = new RpcRequest("rootSubscribe", new ArrayList<Object>());
        this.addSubscription(rpcRequest, listener);
    }

    public void rootUnsubscribe(String subscriptionId) {
        this.unsubscribe("rootUnsubscribe", subscriptionId);
    }

    public void slotSubscribe(NotificationEventListener listener) {
        RpcRequest rpcRequest = new RpcRequest("slotSubscribe", new ArrayList<Object>());
        this.addSubscription(rpcRequest, listener);
    }

    public void slotUnsubscribe(String subscriptionId) {
        this.unsubscribe("slotUnsubscribe", subscriptionId);
    }

    public void slotsUpdatesSubscribe(NotificationEventListener listener) {
        RpcRequest rpcRequest = new RpcRequest("slotsUpdatesSubscribe", new ArrayList<Object>());
        this.addSubscription(rpcRequest, listener);
    }

    public void slotsUpdatesUnsubscribe(String subscriptionId) {
        this.unsubscribe("slotsUpdatesUnsubscribe", subscriptionId);
    }

    public void voteSubscribe(NotificationEventListener listener) {
        RpcRequest rpcRequest = new RpcRequest("voteSubscribe", new ArrayList<Object>());
        this.addSubscription(rpcRequest, listener);
    }

    public void voteUnsubscribe(String subscriptionId) {
        this.unsubscribe("voteUnsubscribe", subscriptionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribe(String method, String subscriptionId) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Long.parseLong(subscriptionId));
        RpcRequest unsubRequest = new RpcRequest(method, params);
        JsonAdapter rpcRequestJsonAdapter = this.moshi.adapter(RpcRequest.class);
        this.send(rpcRequestJsonAdapter.toJson((Object)unsubRequest));
        this.subscriptionLock.lock();
        try {
            this.activeSubscriptions.remove(subscriptionId);
            this.subscriptionListeners.remove(Long.parseLong(subscriptionId));
        }
        finally {
            this.subscriptionLock.unlock();
        }
        LOGGER.info("Unsubscribed from " + method + " with ID: " + subscriptionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(RpcRequest rpcRequest, NotificationEventListener listener) {
        String subscriptionId = rpcRequest.getId();
        this.subscriptionLock.lock();
        try {
            this.activeSubscriptions.put(subscriptionId, new SubscriptionParams(rpcRequest, listener));
            this.subscriptions.put(subscriptionId, new SubscriptionParams(rpcRequest, listener));
            this.subscriptionIds.put(subscriptionId, 0L);
        }
        finally {
            this.subscriptionLock.unlock();
        }
        this.updateSubscriptions();
    }

    public void onOpen(ServerHandshake handshakedata) {
        LOGGER.info("WebSocket connection opened");
        this.reconnectDelay = 1000;
        this.startHeartbeat();
        this.connectLatch.countDown();
    }

    public void onMessage(String message) {
        try {
            JsonAdapter resultAdapter = this.moshi.adapter((Type)Types.newParameterizedType(RpcResponse.class, (Type[])new Type[]{Long.class}));
            RpcResponse rpcResult = (RpcResponse)resultAdapter.fromJson(message);
            if (rpcResult != null && rpcResult.getError() != null) {
                throw new IllegalStateException(rpcResult.getError().toString());
            }
            if (rpcResult != null && rpcResult.getId() != null) {
                this.handleSubscriptionResponse(rpcResult);
            } else {
                this.handleNotification(message);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error processing message", ex);
        }
    }

    private void handleSubscriptionResponse(RpcResponse<Long> rpcResult) {
        String rpcResultId = rpcResult.getId();
        if (this.subscriptionIds.containsKey(rpcResultId)) {
            this.subscriptionIds.put(rpcResultId, rpcResult.getResult());
            SubscriptionParams params = this.subscriptions.get(rpcResultId);
            if (params != null) {
                this.subscriptionListeners.put(rpcResult.getResult(), params.listener);
                this.subscriptions.remove(rpcResultId);
                this.activeSubscriptions.put(String.valueOf(rpcResult.getResult()), params);
                this.activeSubscriptions.remove(rpcResultId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotification(String message) throws Exception {
        JsonAdapter notificationResultAdapter = this.moshi.adapter(RpcNotificationResult.class);
        RpcNotificationResult result = (RpcNotificationResult)notificationResultAdapter.fromJson(message);
        if (result != null) {
            Long subscriptionId = result.getParams().getSubscription();
            this.listenerLock.lock();
            try {
                NotificationEventListener listener = this.subscriptionListeners.get(subscriptionId);
                if (listener != null) {
                    Map value = (Map)result.getParams().getResult().getValue();
                    switch (result.getMethod()) {
                        case "signatureNotification": {
                            listener.onNotificationEvent(new SignatureNotification(value.get("err")));
                            break;
                        }
                        case "accountNotification": 
                        case "logsNotification": 
                        case "blockNotification": 
                        case "programNotification": 
                        case "rootNotification": 
                        case "slotNotification": 
                        case "slotsUpdatesNotification": 
                        case "voteNotification": {
                            listener.onNotificationEvent(value);
                            break;
                        }
                        default: {
                            LOGGER.warning("Unknown notification method: " + result.getMethod());
                            break;
                        }
                    }
                }
                LOGGER.warning("No listener found for subscription ID: " + subscriptionId);
            }
            finally {
                this.listenerLock.unlock();
            }
        } else {
            LOGGER.warning("Received null notification result");
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        LOGGER.info("Connection closed by " + (remote ? "remote peer" : "us") + " Code: " + code + " Reason: " + reason);
        this.stopHeartbeat();
        if (remote || code != 1000) {
            this.scheduleReconnect();
        }
    }

    public void onError(Exception ex) {
        LOGGER.log(Level.SEVERE, "WebSocket error occurred", ex);
        if (ex instanceof WebsocketNotConnectedException) {
            LOGGER.severe("WebSocket is not connected. Attempting to reconnect...");
            this.reconnect();
        } else if (ex instanceof IncompleteHandshakeException) {
            LOGGER.severe("Incomplete handshake. Check your connection parameters.");
        } else if (ex instanceof SocketTimeoutException) {
            LOGGER.severe("Connection timed out. Check network stability and server responsiveness.");
        } else {
            LOGGER.severe("Unexpected error: " + ex.getMessage());
        }
    }

    public void reconnect() {
        LOGGER.info("Attempting to reconnect...");
        try {
            boolean reconnectBlocking = this.reconnectBlocking();
            if (reconnectBlocking) {
                this.resubscribeAll();
            }
        }
        catch (InterruptedException e) {
            LOGGER.warning("Reconnection interrupted: " + e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    private void startHeartbeat() {
        this.executor.scheduleAtFixedRate(() -> ((SubscriptionWebSocketClient)this).sendPing(), 30L, 30L, TimeUnit.SECONDS);
    }

    private void stopHeartbeat() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(800L, TimeUnit.MILLISECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private void updateSubscriptions() {
        if (this.isOpen()) {
            JsonAdapter rpcRequestJsonAdapter = this.moshi.adapter(RpcRequest.class);
            for (SubscriptionParams subscriptionParams : this.subscriptions.values()) {
                this.send(rpcRequestJsonAdapter.toJson((Object)subscriptionParams.request));
            }
            for (Map.Entry entry : this.subscriptionIds.entrySet()) {
                SubscriptionParams params;
                if ((Long)entry.getValue() == 0L || (params = this.subscriptions.get(entry.getKey())) == null) continue;
                this.send(rpcRequestJsonAdapter.toJson((Object)params.request));
            }
        }
    }

    private void scheduleReconnect() {
        this.executor.schedule(() -> {
            this.reconnect();
            this.reconnectDelay = Math.min(this.reconnectDelay * 2, 30000);
        }, (long)this.reconnectDelay, TimeUnit.MILLISECONDS);
    }

    public boolean waitForConnection(long timeout, TimeUnit unit) throws InterruptedException {
        return this.connectLatch.await(timeout, unit);
    }

    private void resubscribeAll() {
        LOGGER.info("Resubscribing to all active subscriptions");
        this.cleanSubscriptions();
        HashMap<String, SubscriptionParams> activeSubscriptionsResubscribe = new HashMap<String, SubscriptionParams>();
        for (Map.Entry<String, SubscriptionParams> entry : this.activeSubscriptions.entrySet()) {
            SubscriptionParams paramsOld = entry.getValue();
            RpcRequest rpcRequest = paramsOld.request;
            NotificationEventListener notificationEventListener = paramsOld.listener;
            RpcRequest request = new RpcRequest(rpcRequest.getMethod(), rpcRequest.getParams());
            String subscriptionId = request.getId();
            SubscriptionParams params = new SubscriptionParams(request, notificationEventListener);
            this.subscriptions.put(subscriptionId, params);
            this.subscriptionIds.put(subscriptionId, 0L);
            activeSubscriptionsResubscribe.put(subscriptionId, params);
        }
        this.activeSubscriptions.clear();
        this.activeSubscriptions.putAll(activeSubscriptionsResubscribe);
        this.updateSubscriptions();
    }

    private void cleanSubscriptions() {
        this.subscriptions.clear();
        this.subscriptionIds.clear();
        this.subscriptionListeners.clear();
    }

    public void unsubscribe(String subscriptionId) {
        SubscriptionParams params = this.activeSubscriptions.remove(subscriptionId);
        if (params != null) {
            ArrayList<Object> unsubParams = new ArrayList<Object>();
            unsubParams.add(Long.parseLong(subscriptionId));
            RpcRequest unsubRequest = new RpcRequest(this.getUnsubscribeMethod(params.request.getMethod()), unsubParams);
            JsonAdapter rpcRequestJsonAdapter = this.moshi.adapter(RpcRequest.class);
            this.send(rpcRequestJsonAdapter.toJson((Object)unsubRequest));
            this.subscriptionListeners.remove(Long.parseLong(subscriptionId));
            LOGGER.info("Unsubscribed from subscription: " + subscriptionId);
        } else {
            LOGGER.warning("Attempted to unsubscribe from non-existent subscription: " + subscriptionId);
        }
    }

    private String getUnsubscribeMethod(String subscribeMethod) {
        switch (subscribeMethod) {
            case "accountSubscribe": {
                return "accountUnsubscribe";
            }
            case "logsSubscribe": {
                return "logsUnsubscribe";
            }
            case "signatureSubscribe": {
                return "signatureUnsubscribe";
            }
            case "blockSubscribe": {
                return "blockUnsubscribe";
            }
            case "programSubscribe": {
                return "programUnsubscribe";
            }
            case "rootSubscribe": {
                return "rootUnsubscribe";
            }
            case "slotSubscribe": {
                return "slotUnsubscribe";
            }
            case "slotsUpdatesSubscribe": {
                return "slotsUpdatesUnsubscribe";
            }
            case "voteSubscribe": {
                return "voteUnsubscribe";
            }
        }
        throw new IllegalArgumentException("Unknown subscribe method: " + subscribeMethod);
    }

    public String getSubscriptionId(String account) {
        for (Map.Entry<String, SubscriptionParams> entry : this.activeSubscriptions.entrySet()) {
            if (!entry.getValue().request.getParams().get(0).equals(account)) continue;
            return entry.getKey();
        }
        return null;
    }

    private static class SubscriptionParams {
        final RpcRequest request;
        final NotificationEventListener listener;

        SubscriptionParams(RpcRequest request, NotificationEventListener listener) {
            this.request = request;
            this.listener = listener;
        }
    }
}

