/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.ws.listeners;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.rpc.RpcClient;
import org.p2p.solanaj.ws.listeners.NotificationEventListener;

public class LogNotificationEventListener
implements NotificationEventListener {
    private static final Logger LOGGER = Logger.getLogger(LogNotificationEventListener.class.getName());
    private final RpcClient client;
    private final PublicKey listeningPubkey;

    public LogNotificationEventListener(RpcClient client, PublicKey listeningPubkey) {
        this.client = client;
        this.listeningPubkey = listeningPubkey;
    }

    @Override
    public void onNotificationEvent(Object data) {
        if (data == null) {
            LOGGER.warning("Received null data in onNotificationEvent");
            return;
        }
        if (!(data instanceof Map)) {
            LOGGER.warning("Received invalid data type in onNotificationEvent: " + data.getClass().getName());
            return;
        }
        Map rawMap = (Map)data;
        HashMap notificationData = new HashMap();
        for (Map.Entry entry : rawMap.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            notificationData.put((String)entry.getKey(), entry.getValue());
        }
        String signature = (String)notificationData.get("signature");
        List<String> logs = null;
        Object logsObj = notificationData.get("logs");
        if (logsObj instanceof List) {
            logs = ((List)logsObj).stream().filter(String.class::isInstance).map(String.class::cast).toList();
        }
        if (signature == null || logs == null || logs.isEmpty()) {
            LOGGER.warning("Missing required fields in notification data");
            return;
        }
        LOGGER.info("Received notification for transaction: " + signature);
        for (String log : logs) {
            LOGGER.info("Log: " + log);
        }
    }

    public RpcClient getClient() {
        return this.client;
    }

    public PublicKey getListeningPubkey() {
        return this.listeningPubkey;
    }
}

