/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen.proc;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class BCELClassAnalyzer {
    private Map<java.lang.reflect.Method, Method> methodMap = new HashMap<java.lang.reflect.Method, Method>();

    public BCELClassAnalyzer(Class<?> clazz) {
        try {
            this.prepareMethodMap(clazz);
        }
        catch (ClassNotFoundException exc) {
            throw new RuntimeException(exc);
        }
    }

    public boolean isMethodDeprecated(java.lang.reflect.Method reflectMethod) {
        Method bcelMethod = this.getBCELMethod(reflectMethod);
        if (null == bcelMethod) {
            return false;
        }
        Attribute[] attributes = bcelMethod.getAttributes();
        DeprecatedVisitor visitor = new DeprecatedVisitor();
        for (Attribute attribute : attributes) {
            attribute.accept((Visitor)visitor);
            if (!visitor.isDeprecated()) continue;
            return true;
        }
        return false;
    }

    public String[] getArgumentNames(java.lang.reflect.Method reflectMethod) {
        int firstIndex;
        Method bcelMethod = this.getBCELMethod(reflectMethod);
        if (null == bcelMethod) {
            return null;
        }
        LocalVariableTable table = bcelMethod.getLocalVariableTable();
        if (null == table) {
            return null;
        }
        LocalVariable[] variables = table.getLocalVariableTable();
        if (null == variables) {
            return null;
        }
        for (firstIndex = 0; firstIndex < variables.length && variables[firstIndex].getName().equals("this"); ++firstIndex) {
        }
        Type[] types = bcelMethod.getArgumentTypes();
        if (null == types) {
            return null;
        }
        if (variables.length - firstIndex < types.length) {
            return null;
        }
        String[] names = new String[types.length];
        for (int ii = 0; ii < types.length; ++ii) {
            names[ii] = variables[firstIndex + ii].getName();
        }
        return names;
    }

    private Method getBCELMethod(java.lang.reflect.Method reflectMethod) {
        return this.methodMap.get(reflectMethod);
    }

    private void prepareMethodMap(Class<?> clazz) throws ClassNotFoundException {
        java.lang.reflect.Method[] reflectMethods = clazz.getDeclaredMethods();
        JavaClass javaClass = Repository.lookupClass(clazz);
        Method[] bcelMethods = javaClass.getMethods();
        ArrayList<java.lang.reflect.Method> reflectMethodList = new ArrayList<java.lang.reflect.Method>(Arrays.asList(reflectMethods));
        ArrayList<Method> bcelMethodList = new ArrayList<Method>(Arrays.asList(bcelMethods));
        while (!reflectMethodList.isEmpty()) {
            this.findAndAddBCELMethod(reflectMethodList, bcelMethodList);
        }
    }

    private void findAndAddBCELMethod(List<java.lang.reflect.Method> reflectMethodList, List<Method> bcelMethodList) {
        java.lang.reflect.Method reflectMethod = reflectMethodList.remove(0);
        for (Method bcelMethod : bcelMethodList) {
            if (!this.areMethodsEqual(reflectMethod, bcelMethod)) continue;
            this.methodMap.put(reflectMethod, bcelMethod);
        }
    }

    private boolean areMethodsEqual(java.lang.reflect.Method reflectMethod, Method bcelMethod) {
        Class<?> bcelReturnType;
        if (null == reflectMethod || null == bcelMethod) {
            return false;
        }
        if (!reflectMethod.getName().equals(bcelMethod.getName())) {
            return false;
        }
        Class<?> reflectReturnType = reflectMethod.getReturnType();
        if (!reflectReturnType.equals(bcelReturnType = this.typeToClass(bcelMethod.getReturnType()))) {
            return false;
        }
        Object[] reflectArgumentTypes = reflectMethod.getParameterTypes();
        Object[] bcelArgumentTypes = this.getBCELArgumentList(bcelMethod);
        return Arrays.equals(reflectArgumentTypes, bcelArgumentTypes);
    }

    private Class<?>[] getBCELArgumentList(Method bcelMethod) {
        Type[] bcelArguments = bcelMethod.getArgumentTypes();
        ArrayList argumentList = new ArrayList();
        for (Type bcelArgument : bcelArguments) {
            Class<?> currentClass = this.typeToClass(bcelArgument);
            if (null == currentClass) continue;
            argumentList.add(currentClass);
        }
        return argumentList.toArray(new Class[argumentList.size()]);
    }

    private Class<?> typeToClass(Type type) {
        if (!(type instanceof ArrayType)) {
            return this.simpleTypeToClass(type);
        }
        ArrayType arrayType = (ArrayType)type;
        Class<?> basicClass = this.simpleTypeToClass(arrayType.getBasicType());
        if (null == basicClass) {
            return null;
        }
        return Array.newInstance(basicClass, new int[arrayType.getDimensions()]).getClass();
    }

    private Class<?> simpleTypeToClass(Type type) {
        if (null == type) {
            return null;
        }
        if (type instanceof BasicType) {
            BasicType basicType = (BasicType)type;
            if (basicType.equals((Object)Type.BOOLEAN)) {
                return Boolean.TYPE;
            }
            if (basicType.equals((Object)Type.BYTE)) {
                return Byte.TYPE;
            }
            if (basicType.equals((Object)Type.CHAR)) {
                return Character.TYPE;
            }
            if (basicType.equals((Object)Type.DOUBLE)) {
                return Double.TYPE;
            }
            if (basicType.equals((Object)Type.FLOAT)) {
                return Float.TYPE;
            }
            if (basicType.equals((Object)Type.INT)) {
                return Integer.TYPE;
            }
            if (basicType.equals((Object)Type.LONG)) {
                return Long.TYPE;
            }
            if (basicType.equals((Object)Type.SHORT)) {
                return Short.TYPE;
            }
            if (basicType.equals((Object)Type.VOID)) {
                return Void.TYPE;
            }
        } else if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            try {
                return Class.forName(objectType.getClassName());
            }
            catch (ClassNotFoundException exc) {
                throw new RuntimeException(exc);
            }
        }
        return null;
    }

    private class DeprecatedVisitor
    extends EmptyVisitor {
        private boolean deprecated = false;

        private DeprecatedVisitor() {
        }

        public void visitDeprecated(Deprecated deprecatedValue) {
            this.deprecated = true;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }
    }
}

