/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen.proc;

import com.mockrunner.base.BasicHTMLOutputTestCase;
import com.mockrunner.base.HTMLOutputModule;
import com.mockrunner.gen.proc.JavaClassGenerator;
import com.mockrunner.gen.proc.StandardAdapterProcessor;
import com.mockrunner.mock.web.WebMockObjectFactory;
import com.mockrunner.util.common.ClassUtil;
import junit.framework.TestCase;

public class BasicAdapterProcessor
extends StandardAdapterProcessor {
    @Override
    protected void addMemberDeclarations(JavaClassGenerator classGenerator, StandardAdapterProcessor.MemberInfo memberInfo) {
        super.addMemberDeclarations(classGenerator, memberInfo);
        String factoryName = ClassUtil.getArgumentName(memberInfo.getFactory());
        memberInfo.setFactoryMember(factoryName);
        classGenerator.addMemberDeclaration(memberInfo.getFactory(), factoryName);
    }

    @Override
    protected String[] getSetUpMethodCodeLines(StandardAdapterProcessor.MemberInfo memberInfo) {
        String[] codeLines = new String[2];
        codeLines[0] = "super.setUp();";
        String getFactoryCall = "get" + ClassUtil.getClassName(memberInfo.getFactory());
        codeLines[1] = memberInfo.getModuleMember() + " = create" + ClassUtil.getClassName(memberInfo.getModule()) + "(" + getFactoryCall + "());";
        return codeLines;
    }

    @Override
    protected String[] getTearDownMethodCodeLines(StandardAdapterProcessor.MemberInfo memberInfo) {
        String[] codeLines = new String[]{"super.tearDown();", memberInfo.getModuleMember() + " = null;", memberInfo.getFactoryMember() + " = null;"};
        return codeLines;
    }

    @Override
    protected void addAdditionalControlMethods(JavaClassGenerator classGenerator, StandardAdapterProcessor.MemberInfo memberInfo) {
        this.addCreateFactoryMethods(classGenerator, memberInfo);
        this.addGetFactoryLazyMethod(classGenerator, memberInfo);
        this.addSetMethod(classGenerator, memberInfo.getFactory(), memberInfo.getFactoryMember());
        this.addCreateModuleMethods(classGenerator, memberInfo);
        super.addAdditionalControlMethods(classGenerator, memberInfo);
    }

    private void addGetFactoryLazyMethod(JavaClassGenerator classGenerator, StandardAdapterProcessor.MemberInfo memberInfo) {
        String[] codeLines = new String[]{"synchronized(" + ClassUtil.getClassName(memberInfo.getFactory()) + ".class)", "{", "    if(" + memberInfo.getFactoryMember() + " == null)", "    {", "        " + memberInfo.getFactoryMember() + " = create" + ClassUtil.getClassName(memberInfo.getFactory()) + "();", "    }", "}", "return " + memberInfo.getFactoryMember() + ";"};
        this.addGetMethod(classGenerator, memberInfo.getFactory(), codeLines);
    }

    @Override
    protected String[] getClassComment(Class<?> module) {
        String link = this.getJavaDocLink(module);
        String[] comment = new String[9];
        String standardClassName = ClassUtil.getPackageName(module) + "." + super.getClassNameFromBaseName(this.getBaseName(module));
        comment[0] = "Delegator for " + link + ". You can";
        comment[1] = "subclass this adapter or use " + link;
        comment[2] = "directly (so your test case can use another base class).";
        comment[3] = "This basic adapter can be used if you don't need any other modules. It";
        comment[4] = "does not extend BaseTestCase.class. If you want";
        comment[5] = "to use several modules in conjunction, consider subclassing";
        comment[6] = "{@link " + standardClassName + "}.";
        comment[7] = "<b>This class is generated from the " + link;
        comment[8] = "and should not be edited directly</b>.";
        return comment;
    }

    @Override
    protected Class<?> getSuperClass(Class<?> module) {
        if (HTMLOutputModule.class.isAssignableFrom(module)) {
            return BasicHTMLOutputTestCase.class;
        }
        return TestCase.class;
    }

    @Override
    protected String getClassNameFromBaseName(String className) {
        return "Basic" + className + "CaseAdapter";
    }

    private void addCreateFactoryMethods(JavaClassGenerator classGenerator, StandardAdapterProcessor.MemberInfo memberInfo) {
        Class<?> factory = memberInfo.getFactory();
        JavaClassGenerator.MethodDeclaration createMethod = this.prepareCreateMethod(factory);
        String[] comment = new String[]{"Creates a " + this.getJavaDocLink(factory) + ".", "@return the created " + this.getJavaDocLink(factory)};
        createMethod.setCommentLines(comment);
        String[] codeLines = new String[]{"return new " + ClassUtil.getClassName(factory) + "();"};
        createMethod.setCodeLines(codeLines);
        classGenerator.addMethodDeclaration(createMethod);
        if (HTMLOutputModule.class.isAssignableFrom(memberInfo.getModule())) {
            createMethod = this.prepareCreateMethod(factory);
            createMethod.setArguments(new Class[]{WebMockObjectFactory.class});
            createMethod.setArgumentNames(new String[]{"otherFactory"});
            codeLines = new String[]{"return new " + ClassUtil.getClassName(factory) + "(otherFactory);"};
            createMethod.setCodeLines(codeLines);
            comment = new String[]{"Same as <code>" + createMethod.getName() + "(otherFactory, true)</code>."};
            createMethod.setCommentLines(comment);
            classGenerator.addMethodDeclaration(createMethod);
            createMethod = this.prepareCreateMethod(factory);
            createMethod.setArguments(new Class[]{WebMockObjectFactory.class, Boolean.TYPE});
            createMethod.setArgumentNames(new String[]{"otherFactory", "createNewSession"});
            codeLines = new String[]{"return new " + ClassUtil.getClassName(factory) + "(otherFactory, createNewSession);"};
            createMethod.setCodeLines(codeLines);
            createMethod.setCommentLines(this.getCreateMethodComment(factory));
            classGenerator.addMethodDeclaration(createMethod);
        }
    }

    private void addCreateModuleMethods(JavaClassGenerator classGenerator, StandardAdapterProcessor.MemberInfo memberInfo) {
        Class<?> module = memberInfo.getModule();
        Class<?> factory = memberInfo.getFactory();
        JavaClassGenerator.MethodDeclaration createMethod = this.prepareCreateMethod(module);
        String[] comment = new String[]{"Creates a " + this.getJavaDocLink(module) + " based on the current", this.getJavaDocLink(factory) + ".", "Same as <code>" + createMethod.getName() + "(" + this.createGetFactoryMethodCall(factory) + ")</code>.", "@return the created " + this.getJavaDocLink(module)};
        createMethod.setCommentLines(comment);
        String[] codeLines = new String[]{"return new " + ClassUtil.getClassName(module) + "(" + this.createGetFactoryMethodCall(factory) + ");"};
        createMethod.setCodeLines(codeLines);
        classGenerator.addMethodDeclaration(createMethod);
        createMethod = this.prepareCreateMethod(module);
        comment = new String[]{"Creates a " + this.getJavaDocLink(module) + " with the specified", this.getJavaDocLink(factory) + ".", "@return the created " + this.getJavaDocLink(module)};
        createMethod.setCommentLines(comment);
        createMethod.setArguments(new Class[]{factory});
        createMethod.setArgumentNames(new String[]{"mockFactory"});
        codeLines = new String[]{"return new " + ClassUtil.getClassName(module) + "(mockFactory);"};
        createMethod.setCodeLines(codeLines);
        classGenerator.addMethodDeclaration(createMethod);
    }

    private String createGetFactoryMethodCall(Class<?> factory) {
        return "get" + ClassUtil.getClassName(factory) + "()";
    }

    private JavaClassGenerator.MethodDeclaration prepareCreateMethod(Class<?> clazz) {
        String methodName = "create" + ClassUtil.getClassName(clazz);
        JavaClassGenerator.MethodDeclaration createMethod = this.createProtectedMethod();
        createMethod.setName(methodName);
        createMethod.setReturnType(clazz);
        return createMethod;
    }

    private String[] getCreateMethodComment(Class<?> factory) {
        String link = this.getJavaDocLink(factory);
        String[] comment = new String[]{"Creates a " + link + " based on another ", this.getJavaDocLink(WebMockObjectFactory.class) + ".", "The created " + link + " will have its own", "request and response objects. If you set <i>createNewSession</i>", "to <code>true</code> it will also have its own session object.", "The two factories will share one <code>ServletContext</code>.", "Especially important for multithreading tests.", "If you set <i>createNewSession</i> to false, the two factories", "will share one session. This setting simulates multiple requests", "from the same client.", "@param otherFactory the other factory", "@param createNewSession create a new session for the new factory", "@return the created " + link};
        return comment;
    }
}

