/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen.proc;

import com.mockrunner.base.BaseTestCase;
import com.mockrunner.base.HTMLOutputModule;
import com.mockrunner.base.HTMLOutputTestCase;
import com.mockrunner.gen.proc.AdapterProcessor;
import com.mockrunner.gen.proc.BCELClassAnalyzer;
import com.mockrunner.gen.proc.JavaClassGenerator;
import com.mockrunner.util.common.ArrayUtil;
import com.mockrunner.util.common.ClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class StandardAdapterProcessor
implements AdapterProcessor {
    private String name;
    private String output;

    public void process(Class<?> module, List<String> excludedMethods) {
        JavaClassGenerator classGenerator = new JavaClassGenerator();
        BCELClassAnalyzer analyzer = new BCELClassAnalyzer(module);
        classGenerator.setCreateJavaDocComments(true);
        classGenerator.setPackage(module.getPackage());
        String className = this.getClassNameFromBaseName(this.getBaseName(module));
        this.name = this.getJavaFileName(module, className);
        classGenerator.setClassName(className);
        classGenerator.setAbstract(true);
        Class<?> superClass = this.getSuperClass(module);
        if (null != superClass) {
            classGenerator.setSuperClass(this.getSuperClass(module));
        }
        classGenerator.setClassComment(this.getClassComment(module));
        Class<?> factoryClass = this.determineFactoryClass(module);
        MemberInfo memberInfo = new MemberInfo();
        memberInfo.setModule(module);
        memberInfo.setFactory(factoryClass);
        this.addMemberDeclarations(classGenerator, memberInfo);
        this.addConstructors(classGenerator);
        this.addTearDownMethod(classGenerator, memberInfo);
        this.addSetUpMethod(classGenerator, memberInfo);
        this.addAdditionalControlMethods(classGenerator, memberInfo);
        this.addDelegatorMethods(classGenerator, analyzer, excludedMethods, memberInfo);
        this.output = classGenerator.generate();
    }

    public String getName() {
        return this.name;
    }

    public String getOutput() {
        return this.output;
    }

    private Class<?> determineFactoryClass(Class<?> module) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = module.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 1) continue;
            return constructor.getParameterTypes()[0];
        }
        throw new RuntimeException("Module " + module.getName() + " has no constructor with mock object factory argument");
    }

    private void addTearDownMethod(JavaClassGenerator classGenerator, MemberInfo memberInfo) {
        JavaClassGenerator.MethodDeclaration method = this.createProtectedMethod();
        method.setName("tearDown");
        method.setExceptions(new Class[]{Exception.class});
        method.setCodeLines(this.getTearDownMethodCodeLines(memberInfo));
        classGenerator.addMethodDeclaration(method);
    }

    private void addSetUpMethod(JavaClassGenerator classGenerator, MemberInfo memberInfo) {
        JavaClassGenerator.MethodDeclaration method = this.createProtectedMethod();
        method.setName("setUp");
        method.setExceptions(new Class[]{Exception.class});
        String[] comment = new String[]{"Creates the " + this.getJavaDocLink(memberInfo.getModule()) + ". If you", "overwrite this method, you must call <code>super.setUp()</code>."};
        method.setCommentLines(comment);
        method.setCodeLines(this.getSetUpMethodCodeLines(memberInfo));
        classGenerator.addMethodDeclaration(method);
    }

    private void addHTMLOutputMethods(JavaClassGenerator classGenerator, MemberInfo memberInfo) {
        Class<?> module = memberInfo.getModule();
        if (!HTMLOutputModule.class.isAssignableFrom(module)) {
            return;
        }
        JavaClassGenerator.MethodDeclaration htmlOutputMethod = this.createProtectedMethod();
        htmlOutputMethod.setName("getHTMLOutputModule");
        htmlOutputMethod.setReturnType(HTMLOutputModule.class);
        String[] comment = new String[]{"Returns the " + this.getJavaDocLink(module) + " as", this.getJavaDocLink(HTMLOutputModule.class) + ".", "@return the " + this.getJavaDocLink(HTMLOutputModule.class)};
        htmlOutputMethod.setCommentLines(comment);
        String[] codeLines = new String[]{"return " + memberInfo.getModuleMember() + ";"};
        htmlOutputMethod.setCodeLines(codeLines);
        classGenerator.addMethodDeclaration(htmlOutputMethod);
    }

    private void addDelegatorMethods(JavaClassGenerator classGenerator, BCELClassAnalyzer analyzer, List<String> excludedMethods, MemberInfo memberInfo) {
        Method[] moduleMethods;
        for (Method method : moduleMethods = this.getDelegateMethods(memberInfo.getModule(), excludedMethods)) {
            JavaClassGenerator.MethodDeclaration delegationMethod = this.createProtectedMethod();
            delegationMethod.setName(method.getName());
            delegationMethod.setReturnType(method.getReturnType());
            Class[] exceptions = method.getExceptionTypes();
            if (exceptions.length > 0) {
                delegationMethod.setExceptions(exceptions);
            }
            Class[] parameters = method.getParameterTypes();
            String[] argumentNames = null;
            if (parameters.length > 0) {
                delegationMethod.setArguments(parameters);
                argumentNames = analyzer.getArgumentNames(method);
                if (null == argumentNames || argumentNames.length <= 0) {
                    argumentNames = this.prepareSuitableArgumentNames(parameters);
                }
                delegationMethod.setArgumentNames(argumentNames);
            }
            String delegationCodeLine = this.createDelegationCodeLine(method, memberInfo.getModuleMember(), argumentNames);
            delegationMethod.setCodeLines(new String[]{delegationCodeLine});
            String[] delegationMethodComment = this.createDelegationMethodComment(analyzer, memberInfo.getModule(), method);
            delegationMethod.setCommentLines(delegationMethodComment);
            classGenerator.addMethodDeclaration(delegationMethod);
        }
    }

    private void addConstructors(JavaClassGenerator classGenerator) {
        classGenerator.addConstructorDeclaration();
        JavaClassGenerator.ConstructorDeclaration constructor = new JavaClassGenerator.ConstructorDeclaration();
        constructor.setArguments(new Class[]{String.class});
        constructor.setArgumentNames(new String[]{"name"});
        constructor.setCodeLines(new String[]{"super(name);"});
        classGenerator.addConstructorDeclaration(constructor);
    }

    private String[] prepareSuitableArgumentNames(Class<?>[] arguments) {
        String[] names = new String[arguments.length];
        for (int ii = 0; ii < arguments.length; ++ii) {
            names[ii] = ClassUtil.getArgumentName(arguments[ii]);
        }
        ArrayUtil.ensureUnique((String[])names);
        return names;
    }

    private Method[] getDelegateMethods(Class<?> module, List<String> excludedMethods) {
        Method[] moduleMethods = module.getDeclaredMethods();
        ArrayList<Method> delegateMethods = new ArrayList<Method>();
        for (Method currentMethod : moduleMethods) {
            if (!this.shouldMethodBeAdded(currentMethod, excludedMethods)) continue;
            delegateMethods.add(currentMethod);
        }
        return delegateMethods.toArray(new Method[delegateMethods.size()]);
    }

    private boolean shouldMethodBeAdded(Method currentMethod, List<String> excludedMethods) {
        if (!Modifier.isPublic(currentMethod.getModifiers())) {
            return false;
        }
        if (null == excludedMethods) {
            return true;
        }
        return !excludedMethods.contains(currentMethod.getName());
    }

    private String[] createDelegationMethodComment(BCELClassAnalyzer analyzer, Class<?> module, Method method) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Delegates to {@link ");
        buffer.append(module.getName());
        buffer.append("#");
        buffer.append(method.getName());
        Class<?>[] argumentTypes = method.getParameterTypes();
        if (argumentTypes.length > 0) {
            buffer.append("(");
            for (int ii = 0; ii < argumentTypes.length; ++ii) {
                buffer.append(ClassUtil.getClassName(argumentTypes[ii]));
                if (ii >= argumentTypes.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(")");
        }
        buffer.append("}");
        if (analyzer.isMethodDeprecated(method)) {
            return new String[]{buffer.toString(), "@deprecated"};
        }
        return new String[]{buffer.toString()};
    }

    private String createDelegationCodeLine(Method method, String memberName, String[] argumentNames) {
        StringBuilder buffer = new StringBuilder();
        if (!Void.TYPE.equals(method.getReturnType())) {
            buffer.append("return ");
        }
        buffer.append(memberName);
        buffer.append(".");
        buffer.append(method.getName());
        buffer.append("(");
        if (null != argumentNames) {
            for (int ii = 0; ii < argumentNames.length; ++ii) {
                buffer.append(argumentNames[ii]);
                if (ii >= argumentNames.length - 1) continue;
                buffer.append(", ");
            }
        }
        buffer.append(");");
        return buffer.toString();
    }

    protected Class<?>[] getAdditionalImports() {
        return new Class[0];
    }

    protected String getBaseName(Class<?> module) {
        String name = ClassUtil.getClassName(module);
        int moduleIndex = name.indexOf("Module");
        if (moduleIndex > -1) {
            name = name.substring(0, moduleIndex);
        }
        return name;
    }

    protected void addGetAndSetMethodPair(JavaClassGenerator classGenerator, Class<?> clazz, String memberName) {
        this.addGetMethod(classGenerator, clazz, memberName);
        this.addSetMethod(classGenerator, clazz, memberName);
    }

    protected void addGetMethod(JavaClassGenerator classGenerator, Class<?> clazz, String memberName) {
        this.addGetMethod(classGenerator, clazz, new String[]{"return " + memberName + ";"});
    }

    protected void addGetMethod(JavaClassGenerator classGenerator, Class<?> clazz, String[] codeLines) {
        JavaClassGenerator.MethodDeclaration getMethod = this.createProtectedMethod();
        getMethod.setName("get" + ClassUtil.getClassName(clazz));
        getMethod.setReturnType(clazz);
        String[] comment = new String[]{"Gets the " + this.getJavaDocLink(clazz) + ".", "@return the " + this.getJavaDocLink(clazz)};
        getMethod.setCommentLines(comment);
        getMethod.setCodeLines(codeLines);
        classGenerator.addMethodDeclaration(getMethod);
    }

    protected void addSetMethod(JavaClassGenerator classGenerator, Class<?> clazz, String memberName) {
        JavaClassGenerator.MethodDeclaration setMethod = this.createProtectedMethod();
        setMethod.setName("set" + ClassUtil.getClassName(clazz));
        String[] comment = new String[]{"Sets the " + this.getJavaDocLink(clazz) + ".", "@param " + memberName + " the " + this.getJavaDocLink(clazz)};
        setMethod.setCommentLines(comment);
        setMethod.setArguments(new Class[]{clazz});
        setMethod.setArgumentNames(new String[]{memberName});
        setMethod.setCodeLines(new String[]{"this." + memberName + " = " + memberName + ";"});
        classGenerator.addMethodDeclaration(setMethod);
    }

    protected String getJavaDocLink(Class<?> clazz) {
        return "{@link " + clazz.getName() + "}";
    }

    protected JavaClassGenerator.MethodDeclaration createProtectedMethod() {
        JavaClassGenerator.MethodDeclaration method = new JavaClassGenerator.MethodDeclaration();
        method.setModifier(4);
        return method;
    }

    protected void addMemberDeclarations(JavaClassGenerator classGenerator, MemberInfo memberInfo) {
        String memberName = ClassUtil.getArgumentName(memberInfo.getModule());
        memberInfo.setModuleMember(memberName);
        classGenerator.addMemberDeclaration(memberInfo.getModule(), memberName);
    }

    protected String[] getSetUpMethodCodeLines(MemberInfo memberInfo) {
        String[] codeLines = new String[2];
        codeLines[0] = "super.setUp();";
        String factoryCall = "get" + ClassUtil.getClassName(memberInfo.getFactory());
        codeLines[1] = memberInfo.getModuleMember() + " = create" + ClassUtil.getClassName(memberInfo.getModule()) + "(" + factoryCall + "());";
        return codeLines;
    }

    protected String[] getTearDownMethodCodeLines(MemberInfo memberInfo) {
        return new String[]{"super.tearDown();", memberInfo.getModuleMember() + " = null;"};
    }

    protected void addAdditionalControlMethods(JavaClassGenerator classGenerator, MemberInfo memberInfo) {
        this.addHTMLOutputMethods(classGenerator, memberInfo);
        this.addGetAndSetMethodPair(classGenerator, memberInfo.getModule(), memberInfo.getModuleMember());
    }

    protected String[] getClassComment(Class<?> module) {
        String link = this.getJavaDocLink(module);
        String[] comment = new String[]{"Delegator for " + link + ". You can", "subclass this adapter or use " + link, "directly (so your test case can use another base class).", "This adapter extends BaseTestCase.class.", "It can be used if you want to use several modules in conjunction.", "<b>This class is generated from the " + link, "and should not be edited directly</b>."};
        return comment;
    }

    protected Class<?> getSuperClass(Class<?> module) {
        if (HTMLOutputModule.class.isAssignableFrom(module)) {
            return HTMLOutputTestCase.class;
        }
        return BaseTestCase.class;
    }

    protected String getJavaFileName(Class<?> module, String className) {
        return ClassUtil.getPackageName(module).replace('.', '/') + "/" + className + ".java";
    }

    protected String getClassNameFromBaseName(String className) {
        return className + "CaseAdapter";
    }

    protected class MemberInfo {
        private Class<?> module;
        private String moduleMember;
        private Class<?> factory;
        private String factoryMember;

        protected MemberInfo() {
        }

        public Class<?> getFactory() {
            return this.factory;
        }

        public void setFactory(Class<?> factory) {
            this.factory = factory;
        }

        public String getFactoryMember() {
            return this.factoryMember;
        }

        public void setFactoryMember(String factoryMember) {
            this.factoryMember = factoryMember;
        }

        public Class<?> getModule() {
            return this.module;
        }

        public void setModule(Class<?> module) {
            this.module = module;
        }

        public String getModuleMember() {
            return this.moduleMember;
        }

        public void setModuleMember(String moduleMember) {
            this.moduleMember = moduleMember;
        }
    }
}

