/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.example.struts;

import com.mockrunner.example.struts.AuthenticationForm;
import com.mockrunner.example.struts.AuthenticationStrategy;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class AuthenticationAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthenticationForm authForm = (AuthenticationForm)form;
        String username = authForm.getUsername();
        String password = authForm.getPassword();
        boolean loginOk = this.getAuthenticationStrategy(request).authenticate(username, password);
        if (loginOk) {
            this.addOkMessage(request);
            return mapping.findForward("success");
        }
        this.addLoginErrors(request, username);
        return mapping.findForward("failure");
    }

    private void addLoginErrors(HttpServletRequest request, String username) {
        ActionMessages errors = new ActionMessages();
        if (!this.getAuthenticationStrategy(request).wasLastUserKnown()) {
            ActionMessage error = new ActionMessage("auth.username.unknown", (Object)username);
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        } else if (!this.getAuthenticationStrategy(request).wasLastPasswordOk()) {
            ActionMessage error = new ActionMessage("auth.password.wrong");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        } else {
            ActionMessage error = new ActionMessage("auth.general.error");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        this.saveErrors(request, errors);
    }

    private void addOkMessage(HttpServletRequest request) {
        ActionMessages messages = new ActionMessages();
        messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("auth.login.successful"));
        this.saveMessages(request, messages);
    }

    private AuthenticationStrategy getAuthenticationStrategy(HttpServletRequest request) {
        ServletContext context = request.getSession().getServletContext();
        return (AuthenticationStrategy)context.getAttribute(AuthenticationStrategy.class.getName());
    }
}

