/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.example.struts;

import com.mockrunner.example.struts.MockOrderManager;
import com.mockrunner.example.struts.OrderAction;
import com.mockrunner.example.struts.OrderForm;
import com.mockrunner.example.struts.OrderManager;
import com.mockrunner.mock.web.ActionMockObjectFactory;
import com.mockrunner.mock.web.MockServletContext;
import com.mockrunner.struts.ActionTestModule;
import junit.framework.TestCase;
import org.apache.struts.action.ActionForm;

public class OrderActionTest
extends TestCase {
    private ActionMockObjectFactory mockFactory;
    private ActionTestModule module;
    private MockOrderManager orderManager;
    private OrderForm form;

    protected void setUp() throws Exception {
        super.setUp();
        this.orderManager = new MockOrderManager();
        this.mockFactory = new ActionMockObjectFactory();
        this.module = new ActionTestModule(this.mockFactory);
        MockServletContext context = this.mockFactory.getMockServletContext();
        context.setAttribute(OrderManager.class.getName(), (Object)this.orderManager);
        this.form = (OrderForm)this.module.createActionForm(OrderForm.class);
        this.module.setValidate(true);
    }

    public void testSuccessfulOrder() {
        this.form.setId("testProduct");
        this.form.setAmount(10);
        this.orderManager.setStock("testProduct", 20);
        this.module.actionPerform(OrderAction.class, (ActionForm)this.form);
        this.module.verifyNoActionErrors();
        this.module.verifyNoActionMessages();
        this.module.verifyForward("success");
    }

    public void testFailureOrder() {
        this.module.addRequestParameter("id", "testProduct");
        this.module.addRequestParameter("amount", "10");
        this.orderManager.setStock("testProduct", 5);
        this.module.actionPerform(OrderAction.class, (ActionForm)this.form);
        this.module.verifyNumberActionErrors(1);
        this.module.verifyActionErrorPresent("not.enough.in.stock");
        this.module.verifyActionErrorValue("not.enough.in.stock", "testProduct");
        this.module.verifyNoActionMessages();
        this.module.verifyForward("failure");
    }
}

