/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.struts;

import com.mockrunner.util.common.MethodUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class DynamicMockProxyGenerator {
    private Class proxiedClass;
    private Object delegate;
    private Class additionalInterface;
    private Set methodsToIntercept;
    private Set methodsToDuplicate;

    public DynamicMockProxyGenerator(Class proxiedClass, Object delegate, Method[] methodsToIntercept, Method[] methodsToDuplicate) {
        this(proxiedClass, delegate, methodsToIntercept, methodsToDuplicate, null);
    }

    public DynamicMockProxyGenerator(Class proxiedClass, Object delegate, Method[] methodsToIntercept, Method[] methodsToDuplicate, Class additionalInterface) {
        this.proxiedClass = proxiedClass;
        this.delegate = delegate;
        this.additionalInterface = additionalInterface;
        this.methodsToIntercept = new HashSet();
        this.methodsToIntercept.addAll(Arrays.asList(methodsToIntercept));
        this.methodsToDuplicate = new HashSet();
        this.methodsToDuplicate.addAll(Arrays.asList(methodsToDuplicate));
    }

    public Object createProxy() {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(this.proxiedClass);
        if (null != this.additionalInterface) {
            enhancer.setInterfaces(new Class[]{this.additionalInterface});
        }
        Method[] targetInterceptMethods = this.getActualTargetMethods(this.delegate, this.methodsToIntercept);
        Method[] targetDuplicateMethods = this.getActualTargetMethods(this.delegate, this.methodsToDuplicate);
        enhancer.setCallback((Callback)new DelegatingInterceptor(this.delegate, targetInterceptMethods, targetDuplicateMethods));
        return enhancer.create();
    }

    private Method[] getActualTargetMethods(Object delegate, Set providedMethods) {
        Method[] methods = delegate.getClass().getMethods();
        HashSet actualMethods = new HashSet();
        HashSet tempProvidedMethods = new HashSet(providedMethods);
        for (Method method : methods) {
            this.findAndAddMethod(tempProvidedMethods, method, actualMethods);
        }
        return actualMethods.toArray(new Method[actualMethods.size()]);
    }

    private void findAndAddMethod(Set providedMethods, Method currentMethod, Set actualMethods) {
        Iterator iterator = providedMethods.iterator();
        while (iterator.hasNext()) {
            Method currentMethodToIntercept = (Method)iterator.next();
            if (!MethodUtil.areMethodsEqual((Method)currentMethod, (Method)currentMethodToIntercept)) continue;
            actualMethods.add(currentMethod);
            iterator.remove();
            return;
        }
    }

    private static class DelegatingInterceptor
    implements MethodInterceptor {
        private Object delegate;
        private Method[] methodsToIntercept;
        private Method[] methodsToDuplicate;

        public DelegatingInterceptor(Object delegate, Method[] methodsToIntercept, Method[] methodsToDuplicate) {
            this.delegate = delegate;
            this.methodsToIntercept = methodsToIntercept;
            this.methodsToDuplicate = methodsToDuplicate;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            for (Method aMethodsToIntercept : this.methodsToIntercept) {
                if (!MethodUtil.areMethodsEqual((Method)method, (Method)aMethodsToIntercept)) continue;
                return aMethodsToIntercept.invoke(this.delegate, args);
            }
            for (Method aMethodsToDuplicate : this.methodsToDuplicate) {
                if (!MethodUtil.areMethodsEqual((Method)method, (Method)aMethodsToDuplicate)) continue;
                aMethodsToDuplicate.invoke(this.delegate, args);
            }
            return proxy.invokeSuper(obj, args);
        }
    }
}

