/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.util.queue.internal;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.munit.tools.util.queue.api.TemporaryQueueRule;
import org.mule.munit.tools.util.queue.internal.error.QueueErrorTypeProvider;
import org.mule.munit.tools.util.queue.internal.error.QueueTimeOutException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class QueueOperations {
    @Inject
    protected TemporaryQueueRule temporaryQueueRule;

    @Throws(value={QueueErrorTypeProvider.class})
    public void queue(@Content TypedValue<Serializable> value, @org.mule.runtime.extension.api.annotation.param.Optional String queueName) {
        this.temporaryQueueRule.push((Serializable)value, queueName);
    }

    @Throws(value={QueueErrorTypeProvider.class})
    public Result<Serializable, Void> dequeue(@org.mule.runtime.extension.api.annotation.param.Optional String queueName, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="10000") Long timeout, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="MILLISECONDS") TimeUnit timeoutUnit) {
        return Optional.ofNullable(this.temporaryQueueRule.pop(queueName, timeoutUnit.toMillis(timeout))).map(this::asResult).orElseThrow(() -> queueName == null ? new QueueTimeOutException() : new QueueTimeOutException(queueName));
    }

    private Result<Serializable, Void> asResult(Object value) {
        TypedValue typedValue = value instanceof TypedValue ? (TypedValue)value : new TypedValue((Object)((Serializable)value), DataType.fromType(value.getClass()));
        return Result.builder().output((Object)((Serializable)typedValue.getValue())).mediaType(typedValue.getDataType().getMediaType()).build();
    }
}

