/*
 * BridJ - Dynamic and blazing-fast native interop for Java.
 * http://bridj.googlecode.com/
 *
 * Copyright (c) 2010-2013, Olivier Chafik (http://ochafik.com/)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Olivier Chafik nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY OLIVIER CHAFIK AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.bridj.jawt;

import org.bridj.BridJ;
import org.bridj.CRuntime;
import org.bridj.Pointer;
import org.bridj.TypedPointer;
import org.bridj.ann.Library;
import org.bridj.ann.Runtime;
import org.bridj.Platform;
import java.io.File;

/**
 * Wrapper for library <b>jawt</b><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("jawt")
@Runtime(CRuntime.class)
public class JawtLibrary {

    static {
        try {
            //if (Platform.isLinux()) 
            //	SystemBridJ.getNativeLibrary("headless/libmawt");
            // System.loadLibrary("jawt");
        } catch (Throwable th) {
        }
        BridJ.register();
    }
    /// <i>native declaration : jawt.h</i>
    public static final int JAWT_LOCK_CLIP_CHANGED = 2;
    /// <i>native declaration : jawt.h</i>
    public static final int JAWT_VERSION_1_4 = 65540;
    /// <i>native declaration : jawt.h</i>
    public static final int JAWT_VERSION_1_3 = 65539;
    /// <i>native declaration : jawt.h</i>
    public static final int JAWT_LOCK_SURFACE_CHANGED = 8;
    /// <i>native declaration : jawt.h</i>
    public static final int JAWT_LOCK_ERROR = 1;
    /// <i>native declaration : jawt.h</i>
    public static final int JAWT_LOCK_BOUNDS_CHANGED = 4;

    public native static boolean JAWT_GetAWT(Pointer<JawtLibrary.JNIEnv> env, Pointer<org.bridj.jawt.JAWT> awt);
    /// Pointer to unknown (opaque) type

    public static class JNIEnv extends TypedPointer {

        public JNIEnv(long address) {
            super(address);
        }

        public JNIEnv(Pointer address) {
            super(address);
        }
    };
}
