/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.sources;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.PropertyWithDeploymentContext;
import com.netflix.config.sources.AbstractDynamoDbConfigurationSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDbDeploymentContextTableCache
extends AbstractDynamoDbConfigurationSource<PropertyWithDeploymentContext> {
    private static Logger log = LoggerFactory.getLogger(DynamoDbDeploymentContextTableCache.class);
    static final String contextKeyAttributePropertyName = "com.netflix.config.dynamo.contextKeyAttributeName";
    static final String contextValueAttributePropertyName = "com.netflix.config.dynamo.contextValueAttributeName";
    static final String defaultContextKeyAttribute = "contextKey";
    static final String defaultContextValueAttribute = "contextValue";
    private final DynamicStringProperty contextKeyAttributeName = DynamicPropertyFactory.getInstance().getStringProperty("com.netflix.config.dynamo.contextKeyAttributeName", "contextKey");
    private final DynamicStringProperty contextValueAttributeName = DynamicPropertyFactory.getInstance().getStringProperty("com.netflix.config.dynamo.contextValueAttributeName", "contextValue");
    static final int defaultInitialDelayMillis = 30000;
    static final int defaultDelayMillis = 60000;
    private final int initialDelayMillis;
    private final int delayMillis;
    private ScheduledExecutorService executor;
    private volatile Map<String, PropertyWithDeploymentContext> cachedTable = new HashMap<String, PropertyWithDeploymentContext>();

    public DynamoDbDeploymentContextTableCache() {
        this(30000, 60000);
    }

    public DynamoDbDeploymentContextTableCache(int initialDelayMillis, int delayMillis) {
        this.initialDelayMillis = initialDelayMillis;
        this.delayMillis = delayMillis;
        this.start();
    }

    public DynamoDbDeploymentContextTableCache(ClientConfiguration clientConfiguration) {
        this(clientConfiguration, 30000, 60000);
    }

    public DynamoDbDeploymentContextTableCache(ClientConfiguration clientConfiguration, int initialDelayMillis, int delayMillis) {
        super(clientConfiguration);
        this.initialDelayMillis = initialDelayMillis;
        this.delayMillis = delayMillis;
        this.start();
    }

    public DynamoDbDeploymentContextTableCache(AWSCredentials credentials) {
        this(credentials, 30000, 60000);
    }

    public DynamoDbDeploymentContextTableCache(AWSCredentials credentials, int initialDelayMillis, int delayMillis) {
        super(credentials);
        this.initialDelayMillis = initialDelayMillis;
        this.delayMillis = delayMillis;
        this.start();
    }

    public DynamoDbDeploymentContextTableCache(AWSCredentials credentials, ClientConfiguration clientConfiguration) {
        this(credentials, clientConfiguration, 30000, 60000);
    }

    public DynamoDbDeploymentContextTableCache(AWSCredentials credentials, ClientConfiguration clientConfiguration, int initialDelayMillis, int delayMillis) {
        super(credentials, clientConfiguration);
        this.initialDelayMillis = initialDelayMillis;
        this.delayMillis = delayMillis;
        this.start();
    }

    public DynamoDbDeploymentContextTableCache(AWSCredentialsProvider credentialsProvider) {
        this(credentialsProvider, 30000, 60000);
    }

    public DynamoDbDeploymentContextTableCache(AWSCredentialsProvider credentialsProvider, int initialDelayMillis, int delayMillis) {
        super(credentialsProvider);
        this.initialDelayMillis = initialDelayMillis;
        this.delayMillis = delayMillis;
        this.start();
    }

    public DynamoDbDeploymentContextTableCache(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(credentialsProvider, clientConfiguration, 30000, 60000);
    }

    public DynamoDbDeploymentContextTableCache(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, int initialDelayMillis, int delayMillis) {
        super(credentialsProvider, clientConfiguration);
        this.initialDelayMillis = initialDelayMillis;
        this.delayMillis = delayMillis;
        this.start();
    }

    public DynamoDbDeploymentContextTableCache(AmazonDynamoDB dbClient) {
        this(dbClient, 30000, 60000);
    }

    public DynamoDbDeploymentContextTableCache(AmazonDynamoDB dbClient, int initialDelayMillis, int delayMillis) {
        super(dbClient);
        this.initialDelayMillis = initialDelayMillis;
        this.delayMillis = delayMillis;
        this.start();
    }

    private synchronized void schedule(Runnable runnable) {
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "pollingDynamoTableCache");
                t.setDaemon(true);
                return t;
            }
        });
        this.executor.scheduleWithFixedDelay(runnable, this.initialDelayMillis, this.delayMillis, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    private void start() {
        this.cachedTable = this.loadPropertiesFromTable(this.tableName.get());
        this.schedule(this.getPollingRunnable());
    }

    private Runnable getPollingRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                log.debug("Dynamo cached polling started");
                try {
                    Map<String, PropertyWithDeploymentContext> newMap = DynamoDbDeploymentContextTableCache.this.loadPropertiesFromTable(DynamoDbDeploymentContextTableCache.this.tableName.get());
                    DynamoDbDeploymentContextTableCache.this.cachedTable = newMap;
                }
                catch (Throwable e) {
                    log.error("Error getting result from polling source", e);
                    return;
                }
            }
        };
    }

    @Override
    protected Map<String, PropertyWithDeploymentContext> loadPropertiesFromTable(String table) {
        ScanResult result;
        HashMap<String, PropertyWithDeploymentContext> propertyMap = new HashMap<String, PropertyWithDeploymentContext>();
        Map lastKeysEvaluated = null;
        do {
            ScanRequest scanRequest = new ScanRequest().withTableName(table).withExclusiveStartKey(lastKeysEvaluated);
            result = this.dbScanWithThroughputBackOff(scanRequest);
            for (Map item : result.getItems()) {
                String keyVal = ((AttributeValue)item.get(this.keyAttributeName.get())).getS();
                DeploymentContext.ContextKey contextKey = item.containsKey(this.contextKeyAttributeName.get()) ? DeploymentContext.ContextKey.valueOf((String)((AttributeValue)item.get(this.contextKeyAttributeName.get())).getS()) : null;
                String contextVal = item.containsKey(this.contextValueAttributeName.get()) ? ((AttributeValue)item.get(this.contextValueAttributeName.get())).getS() : null;
                String key = keyVal + ";" + contextKey + ";" + contextVal;
                propertyMap.put(key, new PropertyWithDeploymentContext(contextKey, contextVal, keyVal, ((AttributeValue)item.get(this.valueAttributeName.get())).getS()));
            }
        } while ((lastKeysEvaluated = result.getLastEvaluatedKey()) != null);
        return propertyMap;
    }

    public Collection<PropertyWithDeploymentContext> getProperties() {
        return this.cachedTable.values();
    }
}

