/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy;

import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifierDefault;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHookDefault;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherDefault;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategyDefault;
import java.util.concurrent.atomic.AtomicReference;

public class HystrixPlugins {
    private static final HystrixPlugins INSTANCE = new HystrixPlugins();
    final AtomicReference<HystrixEventNotifier> notifier = new AtomicReference();
    final AtomicReference<HystrixConcurrencyStrategy> concurrencyStrategy = new AtomicReference();
    final AtomicReference<HystrixMetricsPublisher> metricsPublisher = new AtomicReference();
    final AtomicReference<HystrixPropertiesStrategy> propertiesFactory = new AtomicReference();
    final AtomicReference<HystrixCommandExecutionHook> commandExecutionHook = new AtomicReference();

    private HystrixPlugins() {
    }

    public static HystrixPlugins getInstance() {
        return INSTANCE;
    }

    public static void reset() {
        HystrixPlugins.getInstance().notifier.set(null);
        HystrixPlugins.getInstance().concurrencyStrategy.set(null);
        HystrixPlugins.getInstance().metricsPublisher.set(null);
        HystrixPlugins.getInstance().propertiesFactory.set(null);
        HystrixPlugins.getInstance().commandExecutionHook.set(null);
        HystrixMetricsPublisherFactory.reset();
    }

    public HystrixEventNotifier getEventNotifier() {
        if (this.notifier.get() == null) {
            Object impl = HystrixPlugins.getPluginImplementationViaProperty(HystrixEventNotifier.class);
            if (impl == null) {
                this.notifier.compareAndSet(null, HystrixEventNotifierDefault.getInstance());
            } else {
                this.notifier.compareAndSet(null, (HystrixEventNotifier)impl);
            }
        }
        return this.notifier.get();
    }

    public void registerEventNotifier(HystrixEventNotifier impl) {
        if (!this.notifier.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public HystrixConcurrencyStrategy getConcurrencyStrategy() {
        if (this.concurrencyStrategy.get() == null) {
            Object impl = HystrixPlugins.getPluginImplementationViaProperty(HystrixConcurrencyStrategy.class);
            if (impl == null) {
                this.concurrencyStrategy.compareAndSet(null, HystrixConcurrencyStrategyDefault.getInstance());
            } else {
                this.concurrencyStrategy.compareAndSet(null, (HystrixConcurrencyStrategy)impl);
            }
        }
        return this.concurrencyStrategy.get();
    }

    public void registerConcurrencyStrategy(HystrixConcurrencyStrategy impl) {
        if (!this.concurrencyStrategy.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public HystrixMetricsPublisher getMetricsPublisher() {
        if (this.metricsPublisher.get() == null) {
            Object impl = HystrixPlugins.getPluginImplementationViaProperty(HystrixMetricsPublisher.class);
            if (impl == null) {
                this.metricsPublisher.compareAndSet(null, HystrixMetricsPublisherDefault.getInstance());
            } else {
                this.metricsPublisher.compareAndSet(null, (HystrixMetricsPublisher)impl);
            }
        }
        return this.metricsPublisher.get();
    }

    public void registerMetricsPublisher(HystrixMetricsPublisher impl) {
        if (!this.metricsPublisher.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public HystrixPropertiesStrategy getPropertiesStrategy() {
        if (this.propertiesFactory.get() == null) {
            Object impl = HystrixPlugins.getPluginImplementationViaProperty(HystrixPropertiesStrategy.class);
            if (impl == null) {
                this.propertiesFactory.compareAndSet(null, HystrixPropertiesStrategyDefault.getInstance());
            } else {
                this.propertiesFactory.compareAndSet(null, (HystrixPropertiesStrategy)impl);
            }
        }
        return this.propertiesFactory.get();
    }

    public void registerPropertiesStrategy(HystrixPropertiesStrategy impl) {
        if (!this.propertiesFactory.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public HystrixCommandExecutionHook getCommandExecutionHook() {
        if (this.commandExecutionHook.get() == null) {
            Object impl = HystrixPlugins.getPluginImplementationViaProperty(HystrixCommandExecutionHook.class);
            if (impl == null) {
                this.commandExecutionHook.compareAndSet(null, HystrixCommandExecutionHookDefault.getInstance());
            } else {
                this.commandExecutionHook.compareAndSet(null, (HystrixCommandExecutionHook)impl);
            }
        }
        return this.commandExecutionHook.get();
    }

    public void registerCommandExecutionHook(HystrixCommandExecutionHook impl) {
        if (!this.commandExecutionHook.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    private static Object getPluginImplementationViaProperty(Class<?> pluginClass) {
        String classSimpleName = pluginClass.getSimpleName();
        String implementingClass = System.getProperty("hystrix.plugin." + classSimpleName + ".implementation");
        if (implementingClass != null) {
            try {
                Class<?> cls = Class.forName(implementingClass);
                cls = cls.asSubclass(pluginClass);
                return cls.newInstance();
            }
            catch (ClassCastException e) {
                throw new RuntimeException(classSimpleName + " implementation is not an instance of " + classSimpleName + ": " + implementingClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(classSimpleName + " implementation class not found: " + implementingClass, e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(classSimpleName + " implementation not able to be instantiated: " + implementingClass, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(classSimpleName + " implementation not able to be accessed: " + implementingClass, e);
            }
        }
        return null;
    }
}

