/**
 * Copyright 2012 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.netflix.hystrix.contrib.javanica.command.closure;

import com.netflix.hystrix.contrib.javanica.command.AsyncResult;
import com.netflix.hystrix.contrib.javanica.command.ClosureCommand;

/**
 * Specific implementation of {@link ClosureFactory}.
 */
public class AsyncClosureFactory extends AbstractClosureFactory {

    /**
     * {@inheritDoc}.
     */
    @Override
    boolean isClosureCommand(Object closureObj) {
        return closureObj instanceof AsyncResult;
    }

    /**
     * {@inheritDoc}.
     */
    @Override
    Class<? extends ClosureCommand> getClosureCommandType() {
        return AsyncResult.class;
    }

}
