/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.config;

import com.google.common.base.Preconditions;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.config.Property;
import com.netflix.client.config.PropertyResolver;
import com.netflix.client.config.PropertyUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReloadableClientConfig
implements IClientConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadableClientConfig.class);
    private static final String DEFAULT_CLIENT_NAME = "";
    private static final String DEFAULT_NAMESPACE = "ribbon";
    private final Map<IClientConfigKey, Optional<?>> internalProperties = new ConcurrentHashMap();
    private final Map<IClientConfigKey, ReloadableProperty<?>> dynamicProperties = new ConcurrentHashMap();
    private final Map<IClientConfigKey, Runnable> changeActions = new ConcurrentHashMap<IClientConfigKey, Runnable>();
    private final AtomicLong refreshCounter = new AtomicLong();
    private final PropertyResolver resolver;
    private String clientName = "";
    private String namespace = "ribbon";
    private boolean isDynamic = false;
    private volatile String cachedToString = null;

    protected ReloadableClientConfig(PropertyResolver resolver) {
        this.resolver = resolver;
    }

    protected PropertyResolver getPropertyResolver() {
        return this.resolver;
    }

    public final void reload() {
        this.changeActions.values().forEach(Runnable::run);
        this.dynamicProperties.values().forEach(ReloadableProperty::reload);
        this.cachedToString = null;
    }

    @Deprecated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public final String getClientName() {
        return this.clientName;
    }

    @Override
    public String getNameSpace() {
        return this.namespace;
    }

    @Override
    public final void setNameSpace(String nameSpace) {
        this.namespace = nameSpace;
    }

    @Override
    public void loadProperties(String clientName) {
        LOG.info("[{}] loading config", (Object)clientName);
        this.clientName = clientName;
        this.isDynamic = true;
        this.loadDefaultValues();
        this.resolver.onChange(this::reload);
        this.internalProperties.forEach((? super K key, ? super V value) -> LOG.info("[{}] {}={}", new Object[]{clientName, key, value.orElse(null)}));
    }

    @Override
    @Deprecated
    public final Map<String, Object> getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.internalProperties.size());
        this.forEach((key, value) -> result.put(key.key(), String.valueOf(value)));
        return result;
    }

    @Override
    public void forEach(BiConsumer<IClientConfigKey<?>, Object> consumer) {
        this.internalProperties.forEach((? super K key, ? super V value) -> {
            if (value.isPresent()) {
                consumer.accept((IClientConfigKey<?>)key, value.get());
            }
        });
    }

    private <T> void autoRefreshFromPropertyResolver(IClientConfigKey<T> key) {
        this.changeActions.computeIfAbsent(key, ignore -> {
            Supplier<Optional> valueSupplier = () -> this.resolveFromPropertyResolver(key);
            Optional current = valueSupplier.get();
            if (current.isPresent()) {
                this.internalProperties.put(key, current);
            }
            AtomicReference<Optional> previous = new AtomicReference<Optional>(current);
            return () -> {
                Optional next = (Optional)valueSupplier.get();
                if (!next.equals(previous.get())) {
                    LOG.info("[{}] new value for {}: {} -> {}", new Object[]{this.clientName, key.key(), previous.get(), next});
                    previous.set(next);
                    this.internalProperties.put(key, next);
                }
            };
        });
    }

    private synchronized <T> Property<T> getOrCreateProperty(IClientConfigKey<T> key, final Supplier<Optional<T>> valueSupplier, final Supplier<T> defaultSupplier) {
        Preconditions.checkNotNull(valueSupplier, (Object)"defaultValueSupplier cannot be null");
        return this.dynamicProperties.computeIfAbsent(key, ignore -> new ReloadableProperty<T>(){
            private volatile Optional current = Optional.empty();
            private List consumers = new CopyOnWriteArrayList();
            {
                this.reload();
            }

            @Override
            public void onChange(Consumer<T> consumer) {
                this.consumers.add(consumer);
            }

            @Override
            public Optional<T> get() {
                return this.current;
            }

            @Override
            public T getOrDefault() {
                return this.current.orElse(defaultSupplier.get());
            }

            @Override
            public void reload() {
                ReloadableClientConfig.this.refreshCounter.incrementAndGet();
                Optional next = (Optional)valueSupplier.get();
                if (!next.equals(this.current)) {
                    this.current = next;
                    this.consumers.forEach(arg_0 -> 1.lambda$reload$0(next, (Supplier)defaultSupplier, arg_0));
                }
            }

            public String toString() {
                return String.valueOf(this.get());
            }

            private static /* synthetic */ void lambda$reload$0(Optional next, Supplier defaultSupplier2, Consumer consumer) {
                consumer.accept(next.orElseGet(((Supplier)defaultSupplier2)::get));
            }
        });
    }

    @Override
    public final <T> T get(IClientConfigKey<T> key) {
        Optional<?> value = this.internalProperties.get(key);
        if (value == null) {
            if (!this.isDynamic) {
                return null;
            }
            this.set(key, null);
            value = this.internalProperties.get(key);
        }
        return value.orElse(null);
    }

    @Override
    public final <T> Property<T> getGlobalProperty(IClientConfigKey<T> key) {
        LOG.debug("[{}] get global property '{}' with default '{}'", new Object[]{this.clientName, key.key(), key.defaultValue()});
        return this.getOrCreateProperty(key, () -> this.resolver.get(key.key(), key.type()), key::defaultValue);
    }

    @Override
    public final <T> Property<T> getDynamicProperty(IClientConfigKey<T> key) {
        LOG.debug("[{}] get dynamic property key={} ns={}", new Object[]{this.clientName, key.key(), this.getNameSpace()});
        this.get(key);
        return this.getOrCreateProperty(key, () -> this.internalProperties.getOrDefault(key, Optional.empty()), key::defaultValue);
    }

    @Override
    public <T> Property<T> getPrefixMappedProperty(IClientConfigKey<T> key) {
        LOG.debug("[{}] get dynamic property key={} ns={} client={}", new Object[]{this.clientName, key.key(), this.getNameSpace()});
        return this.getOrCreateProperty(key, this.getPrefixedMapPropertySupplier(key), key::defaultValue);
    }

    private <T> Optional<T> resolveFromPropertyResolver(IClientConfigKey<T> key) {
        Optional<T> value;
        if (!StringUtils.isEmpty((String)this.clientName) && (value = this.resolver.get(this.clientName + "." + this.getNameSpace() + "." + key.key(), key.type())).isPresent()) {
            return value;
        }
        return this.resolver.get(this.getNameSpace() + "." + key.key(), key.type());
    }

    @Override
    public <T> Optional<T> getIfSet(IClientConfigKey<T> key) {
        return this.internalProperties.getOrDefault(key, Optional.empty());
    }

    private <T> T resolveValueToType(IClientConfigKey<T> key, Object value) {
        if (value == null) {
            return null;
        }
        Class type = key.type();
        if (!value.getClass().equals(type)) {
            try {
                if (type.equals(String.class)) {
                    return (T)value.toString();
                }
                if (value.getClass().equals(String.class)) {
                    String strValue = (String)value;
                    if (Integer.class.equals(type)) {
                        return (T)Integer.valueOf(strValue);
                    }
                    if (Boolean.class.equals(type)) {
                        return (T)Boolean.valueOf(strValue);
                    }
                    if (Float.class.equals(type)) {
                        return (T)Float.valueOf(strValue);
                    }
                    if (Long.class.equals(type)) {
                        return (T)Long.valueOf(strValue);
                    }
                    if (Double.class.equals(type)) {
                        return (T)Double.valueOf(strValue);
                    }
                    if (TimeUnit.class.equals(type)) {
                        return (T)((Object)TimeUnit.valueOf(strValue));
                    }
                    return PropertyUtils.resolveWithValueOf(type, strValue).orElseThrow(() -> new IllegalArgumentException("Unsupported value type `" + type + "'"));
                }
                return PropertyUtils.resolveWithValueOf(type, value.toString()).orElseThrow(() -> new IllegalArgumentException("Incompatible value type `" + value.getClass() + "` while expecting '" + type + "`"));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error parsing value '" + value + "' for '" + key.key() + "'", e);
            }
        }
        return (T)value;
    }

    private <T> Supplier<Optional<T>> getPrefixedMapPropertySupplier(IClientConfigKey<T> key) {
        Method method;
        try {
            method = key.type().getDeclaredMethod("valueOf", Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Class '" + key.type().getName() + "' must have static method valueOf(Map<String, String>)", e);
        }
        return () -> {
            HashMap values = new HashMap();
            this.resolver.forEach(this.getNameSpace() + "." + key.key(), values::put);
            if (!StringUtils.isEmpty((String)this.clientName)) {
                this.resolver.forEach(this.clientName + "." + this.getNameSpace() + "." + key.key(), values::put);
            }
            try {
                return Optional.ofNullable(method.invoke(null, values));
            }
            catch (Exception e) {
                LOG.warn("Unable to map value for '{}'", (Object)key.key(), (Object)e);
                return Optional.empty();
            }
        };
    }

    @Override
    public final <T> T get(IClientConfigKey<T> key, T defaultValue) {
        return Optional.ofNullable(this.get(key)).orElse(defaultValue);
    }

    protected final <T> void setDefault(IClientConfigKey<T> key) {
        this.setDefault(key, key.defaultValue());
    }

    protected final <T> void setDefault(IClientConfigKey<T> key, T value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        value = this.resolveFromPropertyResolver(key).orElse(value);
        this.internalProperties.put(key, Optional.ofNullable(value));
        if (this.isDynamic) {
            this.autoRefreshFromPropertyResolver(key);
        }
        this.cachedToString = null;
    }

    @Override
    public <T> IClientConfig set(IClientConfigKey<T> key, T value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        value = this.resolveValueToType(key, value);
        if (this.isDynamic) {
            this.internalProperties.put(key, Optional.ofNullable(this.resolveFromPropertyResolver(key).orElse(value)));
            this.autoRefreshFromPropertyResolver(key);
        } else {
            this.internalProperties.put(key, Optional.ofNullable(value));
        }
        this.cachedToString = null;
        return this;
    }

    @Override
    @Deprecated
    public void setProperty(IClientConfigKey key, Object value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Value may not be null");
        this.set(key, value);
    }

    @Override
    @Deprecated
    public Object getProperty(IClientConfigKey key) {
        return this.get(key);
    }

    @Override
    @Deprecated
    public Object getProperty(IClientConfigKey key, Object defaultVal) {
        return Optional.ofNullable(this.get(key)).orElse(defaultVal);
    }

    @Override
    @Deprecated
    public boolean containsProperty(IClientConfigKey key) {
        return this.internalProperties.containsKey(key);
    }

    @Override
    @Deprecated
    public int getPropertyAsInteger(IClientConfigKey key, int defaultValue) {
        return Optional.ofNullable(this.getProperty(key)).map(Integer.class::cast).orElse(defaultValue);
    }

    @Override
    @Deprecated
    public String getPropertyAsString(IClientConfigKey key, String defaultValue) {
        return Optional.ofNullable(this.getProperty(key)).map(Object::toString).orElse(defaultValue);
    }

    @Override
    @Deprecated
    public boolean getPropertyAsBoolean(IClientConfigKey key, boolean defaultValue) {
        return Optional.ofNullable(this.getProperty(key)).map(Boolean.class::cast).orElse(defaultValue);
    }

    public IClientConfig applyOverride(IClientConfig override) {
        if (override == null) {
            return this;
        }
        override.forEach((key, value) -> this.setProperty((IClientConfigKey)key, value));
        return this;
    }

    public String toString() {
        if (this.cachedToString == null) {
            String newToString;
            this.cachedToString = newToString = this.generateToString();
            return newToString;
        }
        return this.cachedToString;
    }

    public long getRefreshCount() {
        return this.refreshCounter.get();
    }

    private String generateToString() {
        return "ClientConfig:" + this.internalProperties.entrySet().stream().map(t -> {
            if (((IClientConfigKey)t.getKey()).key().endsWith("Password") && ((Optional)t.getValue()).isPresent()) {
                return t.getKey() + ":***";
            }
            return t.getKey() + ":" + ((Optional)t.getValue()).orElse(null);
        }).collect(Collectors.joining(", "));
    }

    static interface ReloadableProperty<T>
    extends Property<T> {
        public void reload();
    }
}

