/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.loadbalancer;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.loadbalancer.Server;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

@SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class DiscoveryEnabledServer
extends Server {
    private final InstanceInfo instanceInfo;
    private final Server.MetaInfo serviceInfo;

    public DiscoveryEnabledServer(InstanceInfo instanceInfo, boolean useSecurePort) {
        this(instanceInfo, useSecurePort, false);
    }

    public DiscoveryEnabledServer(final InstanceInfo instanceInfo, boolean useSecurePort, boolean useIpAddr) {
        super(useIpAddr ? instanceInfo.getIPAddr() : instanceInfo.getHostName(), instanceInfo.getPort());
        if (useSecurePort && instanceInfo.isPortEnabled(InstanceInfo.PortType.SECURE)) {
            super.setPort(instanceInfo.getSecurePort());
        }
        this.instanceInfo = instanceInfo;
        this.serviceInfo = new Server.MetaInfo(){

            public String getAppName() {
                return instanceInfo.getAppName();
            }

            public String getServerGroup() {
                return instanceInfo.getASGName();
            }

            public String getServiceIdForDiscovery() {
                return instanceInfo.getVIPAddress();
            }

            public String getInstanceId() {
                return instanceInfo.getId();
            }
        };
    }

    public InstanceInfo getInstanceInfo() {
        return this.instanceInfo;
    }

    public Server.MetaInfo getMetaInfo() {
        return this.serviceInfo;
    }
}

