/*
 * Decompiled with CFR 0.152.
 */
package rx.concurrency;

import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.DiscardableAction;
import rx.concurrency.SleepingAction;
import rx.util.functions.Action0;
import rx.util.functions.Func2;

public class CurrentThreadScheduler
extends Scheduler {
    private static final CurrentThreadScheduler INSTANCE = new CurrentThreadScheduler();
    private static final ThreadLocal<PriorityQueue<TimedAction>> QUEUE = new ThreadLocal();
    private final AtomicInteger counter = new AtomicInteger(0);

    public static CurrentThreadScheduler getInstance() {
        return INSTANCE;
    }

    private CurrentThreadScheduler() {
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        DiscardableAction<? super T> discardableAction = new DiscardableAction<T>(state, action);
        this.enqueue(discardableAction, this.now());
        return discardableAction;
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, long dueTime, TimeUnit unit) {
        long execTime = this.now() + unit.toMillis(dueTime);
        DiscardableAction<T> discardableAction = new DiscardableAction<T>(state, new SleepingAction<T>(action, this, execTime));
        this.enqueue(discardableAction, execTime);
        return discardableAction;
    }

    private void enqueue(DiscardableAction<?> action, long execTime) {
        boolean exec;
        PriorityQueue<TimedAction> queue = QUEUE.get();
        boolean bl = exec = queue == null;
        if (exec) {
            queue = new PriorityQueue();
            QUEUE.set(queue);
        }
        queue.add(new TimedAction(action, execTime, this.counter.incrementAndGet()));
        if (exec) {
            while (!queue.isEmpty()) {
                queue.poll().action.call(this);
            }
            QUEUE.set(null);
        }
    }

    public static class UnitTest {
        @Test
        public void testNestedActions() {
            final CurrentThreadScheduler scheduler = new CurrentThreadScheduler();
            final Action0 firstStepStart = (Action0)Mockito.mock(Action0.class);
            final Action0 firstStepEnd = (Action0)Mockito.mock(Action0.class);
            final Action0 secondStepStart = (Action0)Mockito.mock(Action0.class);
            final Action0 secondStepEnd = (Action0)Mockito.mock(Action0.class);
            final Action0 thirdStepStart = (Action0)Mockito.mock(Action0.class);
            final Action0 thirdStepEnd = (Action0)Mockito.mock(Action0.class);
            final Action0 firstAction = new Action0(){

                @Override
                public void call() {
                    firstStepStart.call();
                    firstStepEnd.call();
                }
            };
            final Action0 secondAction = new Action0(){

                @Override
                public void call() {
                    secondStepStart.call();
                    scheduler.schedule(firstAction);
                    secondStepEnd.call();
                }
            };
            Action0 thirdAction = new Action0(){

                @Override
                public void call() {
                    thirdStepStart.call();
                    scheduler.schedule(secondAction);
                    thirdStepEnd.call();
                }
            };
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{firstStepStart, firstStepEnd, secondStepStart, secondStepEnd, thirdStepStart, thirdStepEnd});
            scheduler.schedule(thirdAction);
            ((Action0)inOrder.verify((Object)thirdStepStart, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)thirdStepEnd, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)secondStepStart, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)secondStepEnd, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)firstStepStart, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)firstStepEnd, Mockito.times((int)1))).call();
        }

        @Test
        public void testSequenceOfActions() {
            CurrentThreadScheduler scheduler = new CurrentThreadScheduler();
            Action0 first = (Action0)Mockito.mock(Action0.class);
            Action0 second = (Action0)Mockito.mock(Action0.class);
            scheduler.schedule(first);
            scheduler.schedule(second);
            ((Action0)Mockito.verify((Object)first, (VerificationMode)Mockito.times((int)1))).call();
            ((Action0)Mockito.verify((Object)second, (VerificationMode)Mockito.times((int)1))).call();
        }

        @Test
        public void testSequenceOfDelayedActions() {
            final CurrentThreadScheduler scheduler = new CurrentThreadScheduler();
            final Action0 first = (Action0)Mockito.mock(Action0.class);
            final Action0 second = (Action0)Mockito.mock(Action0.class);
            scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    scheduler.schedule(first, 30L, TimeUnit.MILLISECONDS);
                    scheduler.schedule(second, 10L, TimeUnit.MILLISECONDS);
                }
            });
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{first, second});
            ((Action0)inOrder.verify((Object)second, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)first, Mockito.times((int)1))).call();
        }

        @Test
        public void testMixOfDelayedAndNonDelayedActions() {
            final CurrentThreadScheduler scheduler = new CurrentThreadScheduler();
            final Action0 first = (Action0)Mockito.mock(Action0.class);
            final Action0 second = (Action0)Mockito.mock(Action0.class);
            final Action0 third = (Action0)Mockito.mock(Action0.class);
            final Action0 fourth = (Action0)Mockito.mock(Action0.class);
            scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    scheduler.schedule(first);
                    scheduler.schedule(second, 300L, TimeUnit.MILLISECONDS);
                    scheduler.schedule(third, 100L, TimeUnit.MILLISECONDS);
                    scheduler.schedule(fourth);
                }
            });
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{first, second, third, fourth});
            ((Action0)inOrder.verify((Object)first, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)fourth, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)third, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)second, Mockito.times((int)1))).call();
        }
    }

    private static class TimedAction
    implements Comparable<TimedAction> {
        final DiscardableAction<?> action;
        final Long execTime;
        final Integer count;

        private TimedAction(DiscardableAction<?> action, Long execTime, Integer count) {
            this.action = action;
            this.execTime = execTime;
            this.count = count;
        }

        @Override
        public int compareTo(TimedAction that) {
            int result = this.execTime.compareTo(that.execTime);
            if (result == 0) {
                return this.count.compareTo(that.count);
            }
            return result;
        }
    }
}

