/*
 * Decompiled with CFR 0.152.
 */
package rx.concurrency;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import rx.Scheduler;
import rx.concurrency.CurrentThreadScheduler;
import rx.concurrency.ExecutorScheduler;
import rx.concurrency.ImmediateScheduler;
import rx.concurrency.NewThreadScheduler;

public class Schedulers {
    private static final ScheduledExecutorService COMPUTATION_EXECUTOR = Schedulers.createComputationExecutor();
    private static final Executor IO_EXECUTOR = Schedulers.createIOExecutor();

    private Schedulers() {
    }

    public static Scheduler immediate() {
        return ImmediateScheduler.getInstance();
    }

    public static Scheduler currentThread() {
        return CurrentThreadScheduler.getInstance();
    }

    public static Scheduler newThread() {
        return NewThreadScheduler.getInstance();
    }

    public static Scheduler executor(Executor executor) {
        return new ExecutorScheduler(executor);
    }

    public static Scheduler executor(ScheduledExecutorService executor) {
        return new ExecutorScheduler(executor);
    }

    public static Scheduler threadPoolForComputation() {
        return Schedulers.executor(COMPUTATION_EXECUTOR);
    }

    public static Scheduler threadPoolForIO() {
        return Schedulers.executor(IO_EXECUTOR);
    }

    private static ScheduledExecutorService createComputationExecutor() {
        int cores = Runtime.getRuntime().availableProcessors();
        return Executors.newScheduledThreadPool(cores, new ThreadFactory(){
            final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "RxComputationThreadPool-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
    }

    private static Executor createIOExecutor() {
        ExecutorService result = Executors.newCachedThreadPool(new ThreadFactory(){
            final AtomicLong counter = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "RxIOThreadPool-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
        return result;
    }
}

