/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.scriptManager;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.zuul.ZuulApplicationInfo;
import com.netflix.zuul.filters.BaseFilter;
import com.netflix.zuul.scriptManager.FilterInfo;
import groovy.lang.GroovyClassLoader;
import org.codehaus.groovy.control.CompilationFailedException;

public class FilterVerifier {
    @VisibleForTesting
    static final FilterVerifier INSTANCE = new FilterVerifier();

    public static FilterVerifier getInstance() {
        return INSTANCE;
    }

    public FilterInfo verifyFilter(String sFilterCode) throws CompilationFailedException, IllegalAccessException, InstantiationException {
        Class<?> groovyClass = this.compileGroovy(sFilterCode);
        Object instance = this.instantiateClass(groovyClass);
        this.checkZuulFilterInstance(instance);
        BaseFilter filter = (BaseFilter)instance;
        String filter_id = FilterInfo.buildFilterID(ZuulApplicationInfo.getApplicationName(), filter.filterType(), groovyClass.getSimpleName());
        return new FilterInfo(filter_id, sFilterCode, filter.filterType(), groovyClass.getSimpleName(), filter.disablePropertyName(), "" + filter.filterOrder(), ZuulApplicationInfo.getApplicationName());
    }

    Object instantiateClass(Class<?> groovyClass) throws InstantiationException, IllegalAccessException {
        return groovyClass.newInstance();
    }

    void checkZuulFilterInstance(Object zuulFilter) throws InstantiationException {
        if (!(zuulFilter instanceof BaseFilter)) {
            throw new InstantiationException("Code is not a ZuulFilter Class ");
        }
    }

    public Class<?> compileGroovy(String sFilterCode) throws CompilationFailedException {
        GroovyClassLoader loader = new GroovyClassLoader();
        return loader.parseClass(sFilterCode);
    }
}

