/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommPortIdentifier;
import gnu.io.NativeResourceException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class NativeResource {
    private boolean loaded = false;
    private String[] armLibs = new String[]{"libNRJavaSerialv5", "libNRJavaSerialv6_HF", "libNRJavaSerialv6", "libNRJavaSerial_HF", "libNRJavaSerial"};

    public synchronized void load(String libraryName) throws NativeResourceException {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        if (System.getProperty(libraryName + ".userlib") != null) {
            try {
                if (System.getProperty(libraryName + ".userlib").equalsIgnoreCase("sys")) {
                    System.loadLibrary(libraryName);
                } else {
                    System.load(System.getProperty(libraryName + ".userlib"));
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NativeResourceException("Unable to load native resource from given path.\n" + e.getLocalizedMessage());
            }
        }
        this.loadLib(libraryName);
    }

    private void inJarLoad(String name) throws UnsatisfiedLinkError, NativeResourceException {
        InputStream resourceSource = this.locateResource(name);
        File resourceLocation = this.prepResourceLocation(name);
        try {
            this.copyResource(resourceSource, resourceLocation);
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError();
        }
        this.loadResource(resourceLocation);
        this.testNativeCode();
    }

    private void loadLib(String name) throws NativeResourceException {
        String libName = name.substring(name.indexOf("lib") + 3);
        try {
            if (OSUtil.isARM()) {
                for (int i = 0; i < this.armLibs.length; ++i) {
                    try {
                        this.inJarLoad(this.armLibs[i]);
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        continue;
                    }
                }
            } else {
                this.inJarLoad(name);
            }
            return;
        }
        catch (UnsatisfiedLinkError ex) {
            if (OSUtil.isOSX() || OSUtil.isLinux()) {
                try {
                    this.inJarLoad("libNRJavaSerial_legacy");
                    return;
                }
                catch (UnsatisfiedLinkError er) {
                    ex.printStackTrace();
                }
            } else {
                ex.printStackTrace();
            }
            try {
                System.loadLibrary(libName);
                this.testNativeCode();
                return;
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    name = "rxtxSerial";
                    System.loadLibrary(name);
                    this.testNativeCode();
                    return;
                }
                catch (UnsatisfiedLinkError err) {
                    ex.printStackTrace();
                    throw new NativeResourceException("Unable to load deployed native resource");
                }
            }
        }
    }

    private void testNativeCode() throws UnsatisfiedLinkError {
        CommPortIdentifier.getPortIdentifiers();
    }

    private InputStream locateResource(String name) {
        name = name + OSUtil.getExtension();
        String file = "";
        if (OSUtil.isOSX()) {
            file = "/native/osx/" + name;
        } else if (OSUtil.isWindows()) {
            file = OSUtil.is64Bit() ? "/native/windows/x86_64/" + name : "/native/windows/x86_32/" + name;
        } else if (OSUtil.isLinux()) {
            file = OSUtil.isARM() ? "/native/linux/ARM/" + name : (OSUtil.isPPC() ? "/native/linux/PPC/" + name : (OSUtil.is64Bit() ? "/native/linux/x86_64/" + name : "/native/linux/x86_32/" + name));
        } else {
            return null;
        }
        return this.getClass().getResourceAsStream(file);
    }

    private void loadResource(File resource) {
        if (!resource.canRead()) {
            throw new RuntimeException("Cant open JNI file: " + resource.getAbsolutePath());
        }
        System.load(resource.getAbsolutePath());
    }

    private void copyResource(InputStream io, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        byte[] buf = new byte[256];
        int read = 0;
        while ((read = io.read(buf)) > 0) {
            fos.write(buf, 0, read);
        }
        fos.close();
        io.close();
    }

    private File prepResourceLocation(String fileName) throws NativeResourceException {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null || tmpDir.length() == 0) {
            tmpDir = "tmp";
        }
        String displayName = new File(fileName).getName().split("\\.")[0];
        String user = System.getProperty("user.name");
        File fd = null;
        File dir = null;
        for (int i = 0; i < 10; ++i) {
            dir = new File(tmpDir, displayName + "_" + user + "_" + i);
            if (dir.exists()) {
                if (!dir.isDirectory()) continue;
                try {
                    File[] files = dir.listFiles();
                    for (int j = 0; j < files.length; ++j) {
                        if (files[j].delete()) continue;
                    }
                }
                catch (Throwable files) {
                    // empty catch block
                }
            }
            if (!dir.exists() && !dir.mkdirs()) continue;
            try {
                dir.deleteOnExit();
            }
            catch (Throwable files) {
                // empty catch block
            }
            fd = new File(dir, fileName + OSUtil.getExtension());
            if (fd.exists() && !fd.delete()) continue;
            try {
                if (fd.createNewFile()) break;
                continue;
            }
            catch (IOException e) {
                continue;
            }
            catch (Throwable throwable) {
                break;
            }
        }
        if (fd == null || !fd.canRead()) {
            throw new NativeResourceException("Unable to deploy native resource");
        }
        return fd;
    }

    private static class OSUtil {
        private OSUtil() {
        }

        public static boolean is64Bit() {
            return OSUtil.getOsArch().startsWith("x86_64") || OSUtil.getOsArch().startsWith("amd64");
        }

        public static boolean isARM() {
            return OSUtil.getOsArch().startsWith("arm");
        }

        public static boolean isPPC() {
            return OSUtil.getOsArch().toLowerCase().contains("ppc");
        }

        public static boolean isCortexA8() {
            return OSUtil.isARM();
        }

        public static boolean isWindows() {
            return OSUtil.getOsName().toLowerCase().startsWith("windows") || OSUtil.getOsName().toLowerCase().startsWith("microsoft") || OSUtil.getOsName().toLowerCase().startsWith("ms");
        }

        public static boolean isLinux() {
            return OSUtil.getOsName().toLowerCase().startsWith("linux");
        }

        public static boolean isOSX() {
            return OSUtil.getOsName().toLowerCase().startsWith("mac");
        }

        public static String getExtension() {
            if (OSUtil.isWindows()) {
                return ".dll";
            }
            if (OSUtil.isLinux()) {
                return ".so";
            }
            if (OSUtil.isOSX()) {
                return ".jnilib";
            }
            return "";
        }

        public static String getOsName() {
            return System.getProperty("os.name");
        }

        public static String getOsArch() {
            return System.getProperty("os.arch");
        }

        public static String getIdentifier() {
            return OSUtil.getOsName() + " : " + OSUtil.getOsArch();
        }
    }
}

