package com.newrelic.api.agent;

/**
 * Represents a response to a web request.
 * 
 * The implementation of this interface does not need to be servlet specific, but the api is based on the servlet spec.
 * 
 * @author sdaubin
 * 
 * @see NewRelic#setRequestAndResponse(Request, Response)
 * @see javax.servlet.http.HttpServletResponse
 */
public interface Response {
    /**
     * Returns the status code for this response.
     * 
     * @return The status code.
     * @throws Exception Problem getting the status.
     */
    int getStatus() throws Exception;

    /**
     * Returns the error status message, or null if there is none.
     * 
     * @return The error status message.
     * @throws Exception Problem getting status message.
     */
    String getStatusMessage() throws Exception;

    /**
     * Sets a response header with the given name and value.
     * 
     * @param name Name to add to the response header.
     * @param value Value to add to the response header.
     */
    void setHeader(String name, String value);
}
