/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.api.agent.DestinationType;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.InboundHeaders;

public class MessageConsumeParameters
implements ExternalParameters {
    private final String library;
    private final DestinationType destinationType;
    private final String destinationName;
    private final InboundHeaders inboundHeaders;

    protected MessageConsumeParameters(String library, DestinationType destinationType, String destinationName, InboundHeaders inboundHeaders) {
        this.library = library;
        this.destinationType = destinationType;
        this.destinationName = destinationName;
        this.inboundHeaders = inboundHeaders;
    }

    protected MessageConsumeParameters(MessageConsumeParameters messageConsumeParameters) {
        this.library = messageConsumeParameters.library;
        this.destinationType = messageConsumeParameters.destinationType;
        this.destinationName = messageConsumeParameters.destinationName;
        this.inboundHeaders = messageConsumeParameters.inboundHeaders;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public InboundHeaders getInboundHeaders() {
        return this.inboundHeaders;
    }

    public String getLibrary() {
        return this.library;
    }

    public static DestinationTypeParameter library(String library) {
        return new Builder(library);
    }

    public static interface Build {
        public MessageConsumeParameters build();
    }

    public static interface InboundHeadersParameter {
        public Build inboundHeaders(InboundHeaders var1);
    }

    public static interface DestinationNameParameter {
        public InboundHeadersParameter destinationName(String var1);
    }

    public static interface DestinationTypeParameter {
        public DestinationNameParameter destinationType(DestinationType var1);
    }

    protected static class Builder
    implements DestinationTypeParameter,
    DestinationNameParameter,
    InboundHeadersParameter,
    Build {
        private String library;
        private DestinationType destinationType;
        private String destinationName;
        private InboundHeaders inboundHeaders;

        public Builder(String library) {
            this.library = library;
        }

        @Override
        public DestinationNameParameter destinationType(DestinationType destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public InboundHeadersParameter destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        @Override
        public Build inboundHeaders(InboundHeaders inboundHeaders) {
            this.inboundHeaders = inboundHeaders;
            return this;
        }

        @Override
        public MessageConsumeParameters build() {
            return new MessageConsumeParameters(this.library, this.destinationType, this.destinationName, this.inboundHeaders);
        }
    }
}

