/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.common;

import com.nimbusds.infinispan.persistence.common.query.QueryExecutor;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.persistence.spi.AdvancedCacheExpirationWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;

@ThreadSafe
public abstract class InfinispanStore<K, V>
implements AdvancedLoadWriteStore<K, V>,
AdvancedCacheExpirationWriter<K, V> {
    private static Map<String, InfinispanStore> instances = new Hashtable<String, InfinispanStore>();
    private InitializationContext ctx;
    private String cacheName;

    public static Map<String, InfinispanStore> getInstances() {
        return Collections.unmodifiableMap(instances);
    }

    public InitializationContext getInitContext() {
        return this.ctx;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.cacheName = ctx.getCache().getName();
        instances.put(this.cacheName, this);
    }

    public QueryExecutor<K, V> getQueryExecutor() {
        return null;
    }

    public void stop() {
        if (this.cacheName != null) {
            instances.remove(this.cacheName);
        }
    }
}

