/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.common.query;

import com.nimbusds.infinispan.persistence.common.query.MatchQuery;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class SimpleMatchQuery<K, V>
implements MatchQuery<K, V> {
    private final K key;
    private final V value;

    public SimpleMatchQuery(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("The key must not be null");
        }
        this.key = key;
        if (value == null) {
            throw new IllegalArgumentException("The value must not be null");
        }
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public Map<K, V> getMatchMap() {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(this.getKey(), this.getValue());
        return Collections.unmodifiableMap(map);
    }

    public String toString() {
        return "[key=" + this.key + " value=" + this.value + "]";
    }
}

