/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.common.workarounds;

import com.nimbusds.infinispan.persistence.common.InfinispanStore;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.persistence.redis.SimpleRedisStore;

@ThreadSafe
public class EntryCountResolver {
    private final Strategy strategy;
    private final Cache cache;
    private InfinispanStore ispnStore;
    private SimpleRedisStore redisStore;

    public EntryCountResolver(Cache cache) {
        this.cache = cache;
        if (cache.getCacheConfiguration().persistence().usingStores()) {
            boolean passivationOn = cache.getCacheConfiguration().persistence().passivation();
            this.ispnStore = InfinispanStore.getInstances().get(cache.getName());
            if (this.ispnStore != null) {
                this.strategy = passivationOn ? Strategy.DIRECT_WITH_PASSIVATION : Strategy.DIRECT;
                return;
            }
            this.redisStore = (SimpleRedisStore)SimpleRedisStore.getInstances().get(cache.getName());
            if (this.redisStore != null) {
                this.strategy = passivationOn ? Strategy.DIRECT_REDIS_STORE_WITH_PASSIVATION : Strategy.DIRECT_REDIS_STORE;
                return;
            }
        }
        this.strategy = Strategy.DEFAULT;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public int getCount() {
        switch (this.strategy) {
            case DIRECT: {
                return this.ispnStore.size();
            }
            case DIRECT_WITH_PASSIVATION: {
                return this.cache.getAdvancedCache().getDataContainer().size() + this.ispnStore.size();
            }
            case DIRECT_REDIS_STORE: {
                return this.redisStore.size();
            }
            case DIRECT_REDIS_STORE_WITH_PASSIVATION: {
                return this.cache.getAdvancedCache().getDataContainer().size() + this.redisStore.size();
            }
        }
        return this.cache.size();
    }

    static enum Strategy {
        DEFAULT,
        DIRECT,
        DIRECT_WITH_PASSIVATION,
        DIRECT_REDIS_STORE,
        DIRECT_REDIS_STORE_WITH_PASSIVATION;

    }
}

