/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly.websocket;

import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.websocket.AHCWebSocketListenerAdapter;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.util.MiscUtils;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.SimpleWebSocket;
import org.glassfish.grizzly.websockets.WebSocketListener;

public final class GrizzlyWebSocketAdapter
implements WebSocket {
    final SimpleWebSocket gWebSocket;
    final boolean bufferFragments;

    public static GrizzlyWebSocketAdapter newInstance(AsyncHttpProviderConfig<?, ?> config, ProtocolHandler protocolHandler) {
        SimpleWebSocket ws = new SimpleWebSocket(protocolHandler, new WebSocketListener[0]);
        boolean bufferFragments = true;
        if (config instanceof GrizzlyAsyncHttpProviderConfig) {
            bufferFragments = (Boolean)((GrizzlyAsyncHttpProviderConfig)config).getProperty(GrizzlyAsyncHttpProviderConfig.Property.BUFFER_WEBSOCKET_FRAGMENTS);
        }
        return new GrizzlyWebSocketAdapter(ws, bufferFragments);
    }

    private GrizzlyWebSocketAdapter(SimpleWebSocket gWebSocket, boolean bufferFragments) {
        this.gWebSocket = gWebSocket;
        this.bufferFragments = bufferFragments;
    }

    public org.glassfish.grizzly.websockets.WebSocket getGrizzlyWebSocket() {
        return this.gWebSocket;
    }

    @Override
    public WebSocket sendMessage(byte[] message) {
        this.gWebSocket.send(message);
        return this;
    }

    @Override
    public WebSocket stream(byte[] fragment, boolean last) {
        if (MiscUtils.isNonEmpty(fragment)) {
            this.gWebSocket.stream(last, fragment, 0, fragment.length);
        }
        return this;
    }

    @Override
    public WebSocket stream(byte[] fragment, int offset, int len, boolean last) {
        if (MiscUtils.isNonEmpty(fragment)) {
            this.gWebSocket.stream(last, fragment, offset, len);
        }
        return this;
    }

    @Override
    public WebSocket sendMessage(String message) {
        this.gWebSocket.send(message);
        return this;
    }

    @Override
    public WebSocket stream(String fragment, boolean last) {
        this.gWebSocket.stream(last, fragment);
        return this;
    }

    @Override
    public WebSocket sendPing(byte[] payload) {
        this.gWebSocket.sendPing(payload);
        return this;
    }

    @Override
    public WebSocket sendPong(byte[] payload) {
        this.gWebSocket.sendPong(payload);
        return this;
    }

    @Override
    public WebSocket addWebSocketListener(com.ning.http.client.ws.WebSocketListener l) {
        this.gWebSocket.add((WebSocketListener)new AHCWebSocketListenerAdapter(l, this));
        return this;
    }

    @Override
    public WebSocket removeWebSocketListener(com.ning.http.client.ws.WebSocketListener l) {
        this.gWebSocket.remove((WebSocketListener)new AHCWebSocketListenerAdapter(l, this));
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.gWebSocket.isConnected();
    }

    @Override
    public void close() {
        this.gWebSocket.close();
    }
}

