/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.VolumeBind;
import com.github.dockerjava.api.model.VolumeBinds;
import com.github.dockerjava.api.model.VolumeRW;
import com.github.dockerjava.api.model.VolumesRW;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InspectContainerResponse {
    @JsonProperty(value="Args")
    private String[] args;
    @JsonProperty(value="Config")
    private ContainerConfig config;
    @JsonProperty(value="Created")
    private String created;
    @JsonProperty(value="Driver")
    private String driver;
    @JsonProperty(value="ExecDriver")
    private String execDriver;
    @JsonProperty(value="HostConfig")
    private HostConfig hostConfig;
    @JsonProperty(value="HostnamePath")
    private String hostnamePath;
    @JsonProperty(value="HostsPath")
    private String hostsPath;
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="Image")
    private String imageId;
    @JsonProperty(value="MountLabel")
    private String mountLabel;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="NetworkSettings")
    private NetworkSettings networkSettings;
    @JsonProperty(value="Path")
    private String path;
    @JsonProperty(value="ProcessLabel")
    private String processLabel;
    @JsonProperty(value="ResolvConfPath")
    private String resolvConfPath;
    @JsonProperty(value="ExecIDs")
    private List<String> execIds;
    @JsonProperty(value="State")
    private ContainerState state;
    @JsonProperty(value="Volumes")
    private VolumeBinds volumes;
    @JsonProperty(value="VolumesRW")
    private VolumesRW volumesRW;

    public String getId() {
        return this.id;
    }

    public String getCreated() {
        return this.created;
    }

    public String getPath() {
        return this.path;
    }

    public String getProcessLabel() {
        return this.processLabel;
    }

    public String[] getArgs() {
        return this.args;
    }

    public ContainerConfig getConfig() {
        return this.config;
    }

    public ContainerState getState() {
        return this.state;
    }

    public String getImageId() {
        return this.imageId;
    }

    public NetworkSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public String getResolvConfPath() {
        return this.resolvConfPath;
    }

    @JsonIgnore
    public VolumeBind[] getVolumes() {
        return this.volumes.getBinds();
    }

    @JsonIgnore
    public VolumeRW[] getVolumesRW() {
        return this.volumesRW.getVolumesRW();
    }

    public String getHostnamePath() {
        return this.hostnamePath;
    }

    public String getHostsPath() {
        return this.hostsPath;
    }

    public String getName() {
        return this.name;
    }

    public String getDriver() {
        return this.driver;
    }

    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    public String getExecDriver() {
        return this.execDriver;
    }

    public String getMountLabel() {
        return this.mountLabel;
    }

    public List<String> getExecIds() {
        return this.execIds;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public class ContainerState {
        @JsonProperty(value="Running")
        private boolean running;
        @JsonProperty(value="Paused")
        private boolean paused;
        @JsonProperty(value="Pid")
        private int pid;
        @JsonProperty(value="ExitCode")
        private int exitCode;
        @JsonProperty(value="StartedAt")
        private String startedAt;
        @JsonProperty(value="FinishedAt")
        private String finishedAt;

        public boolean isRunning() {
            return this.running;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public int getPid() {
            return this.pid;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getStartedAt() {
            return this.startedAt;
        }

        public String getFinishedAt() {
            return this.finishedAt;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public class NetworkSettings {
        @JsonProperty(value="IPAddress")
        private String ipAddress;
        @JsonProperty(value="IPPrefixLen")
        private int ipPrefixLen;
        @JsonProperty(value="Gateway")
        private String gateway;
        @JsonProperty(value="Bridge")
        private String bridge;
        @JsonProperty(value="PortMapping")
        private Map<String, Map<String, String>> portMapping;
        @JsonProperty(value="Ports")
        private Ports ports;

        public String getIpAddress() {
            return this.ipAddress;
        }

        public int getIpPrefixLen() {
            return this.ipPrefixLen;
        }

        public String getGateway() {
            return this.gateway;
        }

        public String getBridge() {
            return this.bridge;
        }

        public Map<String, Map<String, String>> getPortMapping() {
            return this.portMapping;
        }

        public Ports getPorts() {
            return this.ports;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

