/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.core.FilePathUtil;
import com.github.dockerjava.core.command.AbstrAsyncDockerCmd;
import com.github.dockerjava.core.dockerfile.Dockerfile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import shaded.com.google.common.base.Preconditions;

public class BuildImageCmdImpl
extends AbstrAsyncDockerCmd<BuildImageCmd, BuildResponseItem>
implements BuildImageCmd {
    @CheckForNull
    private InputStream tarInputStream;
    @CheckForNull
    private String tag;
    private boolean noCache;
    private boolean remove = true;
    private boolean quiet;
    private boolean pull;
    @CheckForNull
    private AuthConfigurations buildAuthConfigs;
    @CheckForNull
    private File dockerFile;
    @CheckForNull
    private File baseDirectory;
    @CheckForNull
    private String cpusetcpus;
    @CheckForNull
    private Long memory;
    @CheckForNull
    private String cpushares;
    @CheckForNull
    private Boolean forcerm;
    @CheckForNull
    private Long memswap;
    @CheckForNull
    private URI remote;

    public BuildImageCmdImpl(BuildImageCmd.Exec exec) {
        super(exec);
    }

    public BuildImageCmdImpl(BuildImageCmd.Exec exec, File dockerFileOrFolder) {
        super(exec);
        Preconditions.checkNotNull(dockerFileOrFolder, "dockerFolder is null");
        if (dockerFileOrFolder.isDirectory()) {
            this.withBaseDirectory(dockerFileOrFolder);
            this.withDockerfile(new File(dockerFileOrFolder, "Dockerfile"));
        } else {
            this.withDockerfile(dockerFileOrFolder);
        }
    }

    public BuildImageCmdImpl(BuildImageCmd.Exec exec, InputStream tarInputStream) {
        super(exec);
        Preconditions.checkNotNull(tarInputStream, "tarInputStream is null");
        this.withTarInputStream(tarInputStream);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public URI getRemote() {
        return this.remote;
    }

    @Override
    public boolean hasNoCacheEnabled() {
        return this.noCache;
    }

    @Override
    public boolean hasRemoveEnabled() {
        return this.remove;
    }

    @Override
    public boolean isForcerm() {
        return this.forcerm != null && this.forcerm != false;
    }

    @Override
    public Boolean getForcerm() {
        return this.forcerm;
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public boolean hasPullEnabled() {
        return this.pull;
    }

    @Override
    public String getPathToDockerfile() {
        if (this.baseDirectory != null && this.dockerFile != null) {
            return FilePathUtil.relativize(this.baseDirectory, this.dockerFile);
        }
        return null;
    }

    @Override
    public Long getMemory() {
        return this.memory;
    }

    @Override
    public Long getMemswap() {
        return this.memswap;
    }

    @Override
    public String getCpushares() {
        return this.cpushares;
    }

    @Override
    public String getCpusetcpus() {
        return this.cpusetcpus;
    }

    @Override
    public AuthConfigurations getBuildAuthConfigs() {
        return this.buildAuthConfigs;
    }

    @Override
    public InputStream getTarInputStream() {
        return this.tarInputStream;
    }

    @Override
    public BuildImageCmdImpl withTag(String tag) {
        Preconditions.checkNotNull(tag, "Tag is null");
        this.tag = tag;
        return this;
    }

    @Override
    public BuildImageCmd withRemote(URI remote) {
        this.remote = remote;
        return this;
    }

    @Override
    public BuildImageCmdImpl withNoCache() {
        return this.withNoCache(true);
    }

    @Override
    public BuildImageCmdImpl withNoCache(boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    @Override
    public BuildImageCmdImpl withRemove() {
        return this.withRemove(true);
    }

    @Override
    public BuildImageCmdImpl withRemove(boolean rm) {
        this.remove = rm;
        return this;
    }

    @Override
    public BuildImageCmd withForcerm() {
        return this.withForcerm(true);
    }

    @Override
    public BuildImageCmd withForcerm(Boolean forcerm) {
        this.forcerm = forcerm;
        return this;
    }

    @Override
    public BuildImageCmdImpl withQuiet() {
        return this.withQuiet(true);
    }

    @Override
    public BuildImageCmdImpl withQuiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    @Override
    public BuildImageCmdImpl withPull() {
        return this.withPull(true);
    }

    @Override
    public BuildImageCmdImpl withPull(boolean pull) {
        this.pull = pull;
        return this;
    }

    @Override
    public BuildImageCmd withMemory(long memory) {
        this.memory = memory;
        return this;
    }

    @Override
    public BuildImageCmd withMemswap(long memswap) {
        this.memswap = memswap;
        return this;
    }

    @Override
    public BuildImageCmd withCpushares(String cpushares) {
        this.cpushares = cpushares;
        return this;
    }

    @Override
    public BuildImageCmd withCpusetcpus(String cpusetcpus) {
        this.cpusetcpus = cpusetcpus;
        return this;
    }

    @Override
    public BuildImageCmd withBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        return this;
    }

    @Override
    public BuildImageCmdImpl withDockerfile(File dockerfile) {
        Preconditions.checkNotNull(dockerfile);
        if (!dockerfile.exists()) {
            throw new IllegalArgumentException("Dockerfile does not exist");
        }
        if (!dockerfile.isFile()) {
            throw new IllegalArgumentException("Not a directory");
        }
        if (this.baseDirectory == null) {
            this.withBaseDirectory(dockerfile.getParentFile());
        }
        this.dockerFile = dockerfile;
        try {
            this.withTarInputStream(new Dockerfile(dockerfile).parse().buildDockerFolderTar(this.baseDirectory));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public BuildImageCmdImpl withTarInputStream(InputStream tarInputStream) {
        Preconditions.checkNotNull(tarInputStream, "tarInputStream is null");
        this.tarInputStream = tarInputStream;
        return this;
    }

    @Override
    public BuildImageCmd withBuildAuthConfigs(AuthConfigurations authConfigs) {
        Preconditions.checkNotNull(authConfigs, "authConfig is null");
        this.buildAuthConfigs = authConfigs;
        return this;
    }

    @Override
    public void close() {
        super.close();
        try {
            this.tarInputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
    }
}

