/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import shaded.com.google.common.base.Preconditions;

public class ExecCreateCmdImpl
extends AbstrDockerCmd<ExecCreateCmd, ExecCreateCmdResponse>
implements ExecCreateCmd {
    private String containerId;
    @JsonProperty(value="AttachStdin")
    private boolean attachStdin;
    @JsonProperty(value="AttachStdout")
    private boolean attachStdout;
    @JsonProperty(value="AttachStderr")
    private boolean attachStderr;
    @JsonProperty(value="Tty")
    private boolean tty;
    @JsonProperty(value="Cmd")
    private String[] cmd;

    public ExecCreateCmdImpl(ExecCreateCmd.Exec exec, String containerId) {
        super(exec);
        this.withContainerId(containerId);
    }

    @Override
    public ExecCreateCmd withContainerId(String containerId) {
        Preconditions.checkNotNull(containerId, "containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    public ExecCreateCmd withAttachStdin(boolean attachStdin) {
        this.attachStdin = attachStdin;
        return this;
    }

    @Override
    public ExecCreateCmd withAttachStdin() {
        return this.withAttachStdin(true);
    }

    @Override
    public ExecCreateCmd withAttachStdout(boolean attachStdout) {
        this.attachStdout = attachStdout;
        return this;
    }

    @Override
    public ExecCreateCmd withAttachStdout() {
        return this.withAttachStdout(true);
    }

    @Override
    public ExecCreateCmd withAttachStderr(boolean attachStderr) {
        this.attachStderr = attachStderr;
        return this;
    }

    @Override
    public ExecCreateCmd withAttachStderr() {
        return this.withAttachStderr(true);
    }

    @Override
    public ExecCreateCmd withTty(boolean tty) {
        this.tty = tty;
        return this;
    }

    @Override
    public ExecCreateCmd withTty() {
        return this.withTty(true);
    }

    @Override
    public ExecCreateCmd withCmd(String ... cmd) {
        this.cmd = cmd;
        return this;
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public boolean hasAttachStdinEnabled() {
        return this.attachStdin;
    }

    @Override
    public boolean hasAttachStdoutEnabled() {
        return this.attachStdout;
    }

    @Override
    public boolean hasAttachStderrEnabled() {
        return this.attachStderr;
    }

    @Override
    public boolean hasTtyEnabled() {
        return this.tty;
    }

    @Override
    public ExecCreateCmdResponse exec() throws NotFoundException {
        return (ExecCreateCmdResponse)super.exec();
    }
}

