/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.jaxrs.AbstrSyncDockerCmdExec;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.net.UrlEscapers;

public class ListContainersCmdExec
extends AbstrSyncDockerCmdExec<ListContainersCmd, List<Container>>
implements ListContainersCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListContainersCmdExec.class);

    public ListContainersCmdExec(WebTarget baseResource) {
        super(baseResource);
    }

    @Override
    protected List<Container> execute(ListContainersCmd command) {
        WebTarget webResource = this.getBaseResource().path("/containers/json").queryParam("all", new Object[]{command.hasShowAllEnabled() ? "1" : "0"}).queryParam("since", new Object[]{command.getSinceId()}).queryParam("before", new Object[]{command.getBeforeId()}).queryParam("size", new Object[]{command.hasShowSizeEnabled() ? "1" : "0"});
        if (command.getLimit() >= 0) {
            webResource = webResource.queryParam("limit", new Object[]{String.valueOf(command.getLimit())});
        }
        if (command.getFilters() != null) {
            webResource = webResource.queryParam("filters", new Object[]{UrlEscapers.urlPathSegmentEscaper().escape(command.getFilters().toString())});
        }
        LOGGER.trace("GET: {}", (Object)webResource);
        List containers = (List)webResource.request().accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Container>>(){});
        LOGGER.trace("Response: {}", (Object)containers);
        return containers;
    }
}

