/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import jersey.repackaged.com.google.common.base.Preconditions;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.Initializable;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.collection.UnsafeValue;
import org.glassfish.jersey.internal.util.collection.Values;

public class JerseyClient
implements Client,
Initializable<JerseyClient> {
    private static final Logger LOG = Logger.getLogger(JerseyClient.class.getName());
    private final AtomicBoolean closedFlag = new AtomicBoolean(false);
    private final ClientConfig config;
    private final HostnameVerifier hostnameVerifier;
    private final UnsafeValue<SSLContext, IllegalStateException> sslContext;
    private final LinkedBlockingDeque<ShutdownHook> shutdownHooks = new LinkedBlockingDeque();

    protected JerseyClient() {
        this(null, (UnsafeValue<SSLContext, IllegalStateException>)null, null);
    }

    protected JerseyClient(Configuration config, SSLContext sslContext, HostnameVerifier verifier) {
        this(config, Values.unsafe(sslContext), verifier);
    }

    protected JerseyClient(Configuration config, UnsafeValue<SSLContext, IllegalStateException> sslContextProvider, HostnameVerifier verifier) {
        this.config = config == null ? new ClientConfig(this) : new ClientConfig(this, config);
        this.sslContext = Values.lazy(sslContextProvider != null ? sslContextProvider : this.createSslContextProvider());
        this.hostnameVerifier = verifier;
    }

    private UnsafeValue<SSLContext, IllegalStateException> createSslContextProvider() {
        return new UnsafeValue<SSLContext, IllegalStateException>(){

            @Override
            public SSLContext get() {
                return SslConfigurator.getDefaultContext();
            }
        };
    }

    public void close() {
        if (this.closedFlag.compareAndSet(false, true)) {
            this.release();
        }
    }

    private void release() {
        ShutdownHook listener;
        while ((listener = this.shutdownHooks.pollFirst()) != null) {
            try {
                listener.onShutdown();
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, LocalizationMessages.ERROR_SHUTDOWNHOOK_CLOSE(listener.getClass().getName()), t);
            }
        }
    }

    void registerShutdownHook(ShutdownHook shutdownHook) {
        this.checkNotClosed();
        this.shutdownHooks.push(shutdownHook);
    }

    public boolean isClosed() {
        return this.closedFlag.get();
    }

    void checkNotClosed() {
        Preconditions.checkState(!this.closedFlag.get(), LocalizationMessages.CLIENT_INSTANCE_CLOSED());
    }

    public JerseyWebTarget target(String uri) {
        this.checkNotClosed();
        Preconditions.checkNotNull(uri, LocalizationMessages.CLIENT_URI_TEMPLATE_NULL());
        return new JerseyWebTarget(uri, this);
    }

    public JerseyWebTarget target(URI uri) {
        this.checkNotClosed();
        Preconditions.checkNotNull(uri, LocalizationMessages.CLIENT_URI_NULL());
        return new JerseyWebTarget(uri, this);
    }

    public JerseyWebTarget target(UriBuilder uriBuilder) {
        this.checkNotClosed();
        Preconditions.checkNotNull(uriBuilder, LocalizationMessages.CLIENT_URI_BUILDER_NULL());
        return new JerseyWebTarget(uriBuilder, this);
    }

    public JerseyWebTarget target(Link link) {
        this.checkNotClosed();
        Preconditions.checkNotNull(link, LocalizationMessages.CLIENT_TARGET_LINK_NULL());
        return new JerseyWebTarget(link, this);
    }

    public JerseyInvocation.Builder invocation(Link link) {
        this.checkNotClosed();
        Preconditions.checkNotNull(link, LocalizationMessages.CLIENT_INVOCATION_LINK_NULL());
        JerseyWebTarget t = new JerseyWebTarget(link, this);
        String acceptType = link.getType();
        return acceptType != null ? t.request(acceptType) : t.request();
    }

    public JerseyClient register(Class<?> providerClass) {
        this.checkNotClosed();
        this.config.register((Class)providerClass);
        return this;
    }

    public JerseyClient register(Object provider) {
        this.checkNotClosed();
        this.config.register(provider);
        return this;
    }

    public JerseyClient register(Class<?> providerClass, int bindingPriority) {
        this.checkNotClosed();
        this.config.register((Class)providerClass, bindingPriority);
        return this;
    }

    public JerseyClient register(Class<?> providerClass, Class<?> ... contracts) {
        this.checkNotClosed();
        this.config.register((Class)providerClass, (Class[])contracts);
        return this;
    }

    public JerseyClient register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
        this.checkNotClosed();
        this.config.register((Class)providerClass, (Map)contracts);
        return this;
    }

    public JerseyClient register(Object provider, int bindingPriority) {
        this.checkNotClosed();
        this.config.register(provider, bindingPriority);
        return this;
    }

    public JerseyClient register(Object provider, Class<?> ... contracts) {
        this.checkNotClosed();
        this.config.register(provider, (Class[])contracts);
        return this;
    }

    public JerseyClient register(Object provider, Map<Class<?>, Integer> contracts) {
        this.checkNotClosed();
        this.config.register(provider, (Map)contracts);
        return this;
    }

    public JerseyClient property(String name, Object value) {
        this.checkNotClosed();
        this.config.property(name, value);
        return this;
    }

    @Override
    public ClientConfig getConfiguration() {
        this.checkNotClosed();
        return this.config.getConfiguration();
    }

    public SSLContext getSslContext() {
        return this.sslContext.get();
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Override
    public JerseyClient preInitialize() {
        this.config.preInitialize();
        return this;
    }

    static interface ShutdownHook {
        public void onShutdown();
    }
}

