/*
 * Decompiled with CFR 0.152.
 */
package com.kpelykh.docker.client.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang.StringUtils;

public class CompressArchiveUtil {
    public static File archiveTARFiles(File baseDir, String archiveNameWithOutExtension) throws IOException {
        File tarFile = null;
        tarFile = new File(FileUtils.getTempDirectoryPath(), archiveNameWithOutExtension + ".tar");
        Collection files = FileUtils.listFiles((File)baseDir, (IOFileFilter)new RegexFileFilter("^(.*?)"), (IOFileFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)baseDir.getName()))}));
        byte[] buf = new byte[1024];
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(tarFile));
        tos.setLongFileMode(2);
        for (File file : files) {
            TarArchiveEntry tarEntry = new TarArchiveEntry(file);
            tarEntry.setName(StringUtils.substringAfter((String)file.toString(), (String)baseDir.getPath()));
            tos.putArchiveEntry((ArchiveEntry)tarEntry);
            if (!file.isDirectory()) {
                int len;
                FileInputStream fin = new FileInputStream(file);
                BufferedInputStream in = new BufferedInputStream(fin);
                while ((len = in.read(buf)) != -1) {
                    tos.write(buf, 0, len);
                }
                in.close();
            }
            tos.closeArchiveEntry();
        }
        tos.close();
        return tarFile;
    }
}

