/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.docker.api;

import com.nirima.docker.client.model.Container;
import com.nirima.docker.client.model.ContainerConfig;
import com.nirima.docker.client.model.ContainerCreateResponse;
import com.nirima.docker.client.model.ContainerInspectResponse;
import com.nirima.docker.client.model.FileChanges;
import com.nirima.docker.client.model.HostConfig;
import com.nirima.docker.client.model.StatusCodeResponse;
import com.nirima.docker.client.model.TopResponse;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/containers")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ContainersClient {
    @GET
    @Path(value="/json")
    public List<Container> listContainers(@QueryParam(value="all") boolean var1, @QueryParam(value="limit") int var2, @DefaultValue(value="") @QueryParam(value="since") String var3, @DefaultValue(value="") @QueryParam(value="before") String var4, @QueryParam(value="size") boolean var5);

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/create")
    public ContainerCreateResponse createContainer(@QueryParam(value="name") String var1, ContainerConfig var2);

    @GET
    @Path(value="/{id}/json")
    public ContainerInspectResponse inspectContainer(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/top")
    public TopResponse top(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/changes")
    public List<FileChanges> getFilesystemChanges(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/export")
    public Object exportContainer(@PathParam(value="id") String var1);

    @POST
    @Path(value="/{id}/start")
    @Produces(value={"text/plain"})
    public String startContainer(@PathParam(value="id") String var1, HostConfig var2);

    @POST
    @Path(value="/{id}/stop")
    @Produces(value={"text/plain"})
    public String stopContainer(@PathParam(value="id") String var1, @QueryParam(value="t") Long var2);

    @POST
    @Path(value="/{id}/restart")
    @Produces(value={"text/plain"})
    public String restartContainer(@PathParam(value="id") String var1, @QueryParam(value="t") Long var2);

    @POST
    @Path(value="/{id}/kill")
    @Produces(value={"text/plain"})
    public String killContainer(@PathParam(value="id") String var1);

    @POST
    @Path(value="/{id}/attach")
    @Produces(value={"application/octet-stream"})
    public InputStream attachToContainer(@PathParam(value="id") String var1, @QueryParam(value="logs") boolean var2, @QueryParam(value="stream") boolean var3, @QueryParam(value="stdin") boolean var4, @QueryParam(value="stdout") boolean var5, @QueryParam(value="stderr") boolean var6);

    @POST
    @Path(value="/{id}/wait")
    public StatusCodeResponse waitForContainer(@PathParam(value="id") String var1);

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"text/plain"})
    public void removeContainer(@PathParam(value="id") String var1);

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"text/plain"})
    public void removeContainer(@PathParam(value="id") String var1, @QueryParam(value="v") boolean var2, @QueryParam(value="force") boolean var3);

    @POST
    @Path(value="/{id}/copy")
    public void copy(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/logs")
    public InputStream logs(@PathParam(value="id") String var1, @QueryParam(value="follow") boolean var2, @QueryParam(value="stdout") boolean var3, @QueryParam(value="stderr") boolean var4, @QueryParam(value="timestamps") boolean var5);
}

