/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.httpclient;

import com.noelios.restlet.ext.httpclient.HttpMethodCall;
import com.noelios.restlet.http.HttpClientCall;
import java.io.IOException;
import java.util.logging.Level;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.restlet.Client;
import org.restlet.data.Protocol;
import org.restlet.data.Request;

public class HttpClientHelper
extends com.noelios.restlet.http.HttpClientHelper {
    private volatile HttpClient httpClient = null;

    public HttpClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.HTTP);
        this.getProtocols().add(Protocol.HTTPS);
    }

    public HttpClientCall create(Request request) {
        HttpMethodCall result = null;
        try {
            result = new HttpMethodCall(this, request.getMethod().toString(), request.getResourceRef().toString(), request.isEntityAvailable());
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to create the HTTP client call", ioe);
        }
        return result;
    }

    public int getConnectionManagerTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("connectionManagerTimeout", "0"));
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public int getMaxConnectionsPerHost() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxConnectionsPerHost", "2"));
    }

    public int getMaxTotalConnections() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxTotalConnections", "20"));
    }

    public int getReadTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("readTimeout", "0"));
    }

    public String getRetryHandler() {
        return this.getHelpedParameters().getFirstValue("retryHandler", null);
    }

    public int getStopIdleTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("stopIdleTimeout", "1000"));
    }

    public boolean isFollowRedirects() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("followRedirects", "false"));
    }

    public boolean getTcpNoDelay() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("tcpNoDelay", "false"));
    }

    public void start() throws Exception {
        super.start();
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(this.getMaxConnectionsPerHost());
        connectionManager.getParams().setMaxTotalConnections(this.getMaxTotalConnections());
        connectionManager.getParams().setTcpNoDelay(this.getTcpNoDelay());
        this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        this.getHttpClient().getParams().setAuthenticationPreemptive(false);
        this.getHttpClient().getParams().setConnectionManagerTimeout((long)this.getConnectionManagerTimeout());
        this.getHttpClient().getParams().setCookiePolicy("ignoreCookies");
        this.getHttpClient().getParams().setSoTimeout(this.getReadTimeout());
        this.getLogger().info("Starting the HTTP client");
    }

    public void stop() throws Exception {
        this.getHttpClient().getHttpConnectionManager().closeIdleConnections((long)this.getStopIdleTimeout());
        this.getLogger().info("Stopping the HTTP client");
    }
}

