/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;

public class StatusFilter
extends Filter {
    private volatile String email;
    private volatile String homeURI;
    private volatile boolean overwrite;

    public StatusFilter(Context context, boolean overwrite, String email, String homeUri) {
        super(context);
        this.overwrite = overwrite;
        this.email = email;
        this.homeURI = homeUri;
    }

    public void afterHandle(Request request, Response response) {
        if (response.getStatus() == null) {
            response.setStatus(Status.SUCCESS_OK);
        }
        if (response.getStatus().isError() && (response.getEntity() == null || this.overwrite)) {
            response.setEntity(this.getRepresentation(response.getStatus(), request, response));
        }
    }

    public int doHandle(Request request, Response response) {
        try {
            super.doHandle(request, response);
        }
        catch (Throwable t) {
            response.setStatus(this.getStatus(t, request, response));
        }
        return 0;
    }

    public Representation getRepresentation(Status status, Request request, Response response) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("   <title>Status page</title>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append("<h3>");
        if (status.getDescription() != null) {
            sb.append(status.getDescription());
        } else {
            sb.append("No description available for this result status");
        }
        sb.append("</h3>");
        sb.append("<p>You can get technical details <a href=\"");
        sb.append(status.getUri());
        sb.append("\">here</a>.<br>\n");
        if (this.email != null) {
            sb.append("For further assistance, you can contact the <a href=\"mailto:");
            sb.append(this.email);
            sb.append("\">administrator</a>.<br>\n");
        }
        if (this.homeURI != null) {
            sb.append("Please continue your visit at our <a href=\"");
            sb.append(this.homeURI);
            sb.append("\">home page</a>.\n");
        }
        sb.append("</p>\n");
        sb.append("</body>\n");
        sb.append("</html>\n");
        return new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_HTML);
    }

    public Status getStatus(Throwable throwable, Request request, Response response) {
        this.getLogger().log(Level.SEVERE, "Unhandled exception or error intercepted", throwable);
        return Status.SERVER_ERROR_INTERNAL;
    }
}

