/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import com.noelios.restlet.TemplateDispatcher;
import com.noelios.restlet.application.ApplicationContext;
import org.restlet.data.LocalReference;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class ApplicationClientDispatcher
extends TemplateDispatcher {
    public ApplicationClientDispatcher(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    private ApplicationContext getApplicationContext() {
        return (ApplicationContext)this.getContext();
    }

    public void doHandle(Request request, Response response) {
        Protocol protocol = request.getProtocol();
        if (protocol.equals((Object)Protocol.RIAP)) {
            request.setConfidential(true);
            LocalReference cr = new LocalReference(request.getResourceRef());
            if (cr.getRiapAuthorityType() == 4) {
                request.getResourceRef().setBaseRef(request.getResourceRef().getHostIdentifier());
                if (this.getApplicationContext() != null) {
                    this.getApplicationContext().getApplication().getRoot().handle(request, response);
                }
            } else if (cr.getRiapAuthorityType() == 5) {
                this.parentHandle(request, response);
            } else if (cr.getRiapAuthorityType() == 6) {
                this.parentHandle(request, response);
            } else {
                this.getLogger().warning("Unknown RIAP authority. Only \"component\", \"host\" and \"application\" are supported.");
            }
        } else {
            if (!this.getApplicationContext().getApplication().getConnectorService().getClientProtocols().contains(protocol)) {
                this.getLogger().fine("The protocol used by this request is not declared in the application's connector service. Please update the list of client connectors used by your application and restart it.");
            }
            this.parentHandle(request, response);
        }
    }

    private void parentHandle(Request request, Response response) {
        if (this.getApplicationContext() != null) {
            if (this.getApplicationContext().getParentContext() != null) {
                if (this.getApplicationContext().getParentContext().getClientDispatcher() != null) {
                    this.getApplicationContext().getParentContext().getClientDispatcher().handle(request, response);
                } else {
                    this.getLogger().warning("The parent context doesn't have a client dispatcher available. Unable to handle call.");
                }
            } else {
                this.getLogger().warning("Your Application doesn't have a parent context available. Ensure that your parent Component has a context available.");
            }
        } else {
            this.getLogger().warning("Your Application doesn't have a context set. Ensure that you pass the parent Component's context to your Application constructor.");
        }
    }
}

