/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import com.noelios.restlet.application.ApplicationClientDispatcher;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Uniform;

public class ApplicationContext
extends Context {
    private volatile Application application;
    private volatile ApplicationClientDispatcher clientDispatcher;
    private volatile Context parentContext;
    private volatile Uniform serverDispatcher;

    private static String getLoggerName(Application application) {
        String result = application.getClass().getCanonicalName();
        if (result == null) {
            result = "org.restlet.application";
        }
        return result;
    }

    public ApplicationContext(Application application, Context parentContext, Logger logger) {
        super(ApplicationContext.getLoggerName(application));
        this.application = application;
        this.parentContext = parentContext;
        this.clientDispatcher = new ApplicationClientDispatcher(this);
        this.serverDispatcher = this.getParentContext() != null ? this.getParentContext().getServerDispatcher() : null;
    }

    public Application getApplication() {
        return this.application;
    }

    public ApplicationClientDispatcher getClientDispatcher() {
        return this.clientDispatcher;
    }

    protected Context getParentContext() {
        return this.parentContext;
    }

    public Uniform getServerDispatcher() {
        return this.serverDispatcher;
    }
}

