/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.authentication;

import com.noelios.restlet.Engine;
import com.noelios.restlet.authentication.AuthenticationHelper;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.restlet.Guard;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationUtils {
    private static final Pattern PATTERN_RFC_2617 = Pattern.compile("([^=]+)=\"?([^\",]+)(?:\"\\s*)?,?\\s*");

    public static boolean anyNull(Object ... objects) {
        for (Object o : objects) {
            if (o != null) continue;
            return true;
        }
        return false;
    }

    public static int authenticate(Request request, Guard guard) {
        ChallengeResponse cr;
        int result = 0;
        if (guard.getScheme() != null && (cr = request.getChallengeResponse()) != null && guard.getScheme().equals((Object)cr.getScheme())) {
            AuthenticationHelper helper = Engine.getInstance().findHelper(cr.getScheme(), false, true);
            if (helper != null) {
                result = helper.authenticate(cr, request, guard);
            } else {
                throw new IllegalArgumentException("Challenge scheme " + guard.getScheme() + " not supported by the Restlet engine.");
            }
        }
        if (request.getChallengeResponse() != null) {
            request.getChallengeResponse().setAuthenticated(result == 1);
        }
        return result;
    }

    public static void challenge(Response response, boolean stale, Guard guard) {
        AuthenticationHelper helper = Engine.getInstance().findHelper(guard.getScheme(), false, true);
        if (helper == null) {
            throw new IllegalArgumentException("Challenge scheme " + guard.getScheme() + " not supported by the Restlet engine.");
        }
        helper.challenge(response, stale, guard);
    }

    public static String format(ChallengeRequest request) {
        String result = null;
        AuthenticationHelper helper = Engine.getInstance().findHelper(request.getScheme(), false, true);
        if (helper == null) {
            throw new IllegalArgumentException("Challenge scheme " + request.getScheme() + " not supported by the Restlet engine.");
        }
        result = helper.format(request);
        return result;
    }

    public static String format(ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        String result = null;
        AuthenticationHelper helper = Engine.getInstance().findHelper(challenge.getScheme(), true, false);
        if (helper == null) {
            throw new IllegalArgumentException("Challenge scheme " + challenge.getScheme() + " not supported by the Restlet engine.");
        }
        result = helper.format(challenge, request, httpHeaders);
        return result;
    }

    public static ChallengeRequest parseAuthenticateHeader(String header) {
        AuthenticationHelper helper;
        int space;
        ChallengeRequest result = null;
        if (header != null && (space = header.indexOf(32)) != -1) {
            String scheme = header.substring(0, space);
            result = new ChallengeRequest(new ChallengeScheme("HTTP_" + scheme, scheme), null);
            String rest = header.substring(space + 1);
            AuthenticationUtils.parseParameters(rest, (Series<Parameter>)result.getParameters());
            result.setRealm(result.getParameters().getFirstValue("realm"));
        }
        if ((helper = Engine.getInstance().findHelper(result.getScheme(), true, false)) == null) {
            throw new IllegalArgumentException("Challenge scheme " + result.getScheme() + " not supported by the Restlet engine.");
        }
        helper.parseRequest(result, header);
        return result;
    }

    public static ChallengeResponse parseAuthorizationHeader(Request request, Logger logger, String header) {
        int space;
        ChallengeResponse result = null;
        if (header != null && (space = header.indexOf(32)) != -1) {
            String scheme = header.substring(0, space);
            String credentials = header.substring(space + 1);
            result = new ChallengeResponse(new ChallengeScheme("HTTP_" + scheme, scheme), credentials);
            AuthenticationHelper helper = Engine.getInstance().findHelper(result.getScheme(), true, false);
            if (helper != null) {
                helper.parseResponse(result, request, logger);
            } else {
                throw new IllegalArgumentException("Challenge scheme " + result.getScheme() + " not supported by the Restlet engine.");
            }
        }
        return result;
    }

    public static void parseParameters(String paramString, Series<Parameter> parameters) {
        Matcher matcher = PATTERN_RFC_2617.matcher(paramString);
        while (matcher.find() && matcher.groupCount() == 2) {
            parameters.add(matcher.group(1), matcher.group(2));
        }
    }
}

