/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.authentication;

import com.noelios.restlet.authentication.AuthenticationHelper;
import com.noelios.restlet.authentication.AuthenticationUtils;
import com.noelios.restlet.util.Base64;
import com.noelios.restlet.util.SecurityUtils;
import java.util.logging.Logger;
import javax.security.auth.login.CredentialException;
import org.restlet.Guard;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.util.Engine;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpDigestHelper
extends AuthenticationHelper {
    private static String getHashedSecret(String identifier, Guard guard) {
        return Engine.getInstance().toMd5(identifier + ":" + guard.getRealm() + ":" + new String((char[])guard.getSecretResolver().resolve(identifier)));
    }

    private static boolean isNonceValid(String nonce, String secretKey, long lifespanMS) throws CredentialException {
        try {
            String decodedNonce = new String(Base64.decode(nonce));
            long nonceTimeMS = Long.parseLong(decodedNonce.substring(0, decodedNonce.indexOf(58)));
            if (decodedNonce.equals(nonceTimeMS + ":" + SecurityUtils.toMd5(nonceTimeMS + ":" + secretKey))) {
                return lifespanMS > System.currentTimeMillis() - nonceTimeMS;
            }
        }
        catch (Exception e) {
            throw new CredentialException("error parsing nonce: " + e);
        }
        throw new CredentialException("nonce does not match secretKey");
    }

    public HttpDigestHelper() {
        super(ChallengeScheme.HTTP_DIGEST, true, true);
    }

    @Override
    public int authenticate(ChallengeResponse cr, Request request, Guard guard) {
        Series credentials = cr.getParameters();
        String username = credentials.getFirstValue("username");
        String nonce = credentials.getFirstValue("nonce");
        String response = credentials.getFirstValue("response");
        String uri = credentials.getFirstValue("uri");
        String qop = credentials.getFirstValue("qop");
        String nc = credentials.getFirstValue("nc");
        String cnonce = credentials.getFirstValue("cnonce");
        try {
            if (!HttpDigestHelper.isNonceValid(nonce, guard.getServerKey(), guard.getNonceLifespan())) {
                return 2;
            }
        }
        catch (CredentialException ce) {
            return -1;
        }
        if (!AuthenticationUtils.anyNull(username, nonce, response, uri)) {
            Reference resourceRef = request.getResourceRef();
            String requestUri = resourceRef.getPath();
            if (resourceRef.getQuery() != null && uri.indexOf(63) > -1) {
                requestUri = requestUri + "?" + resourceRef.getQuery();
            }
            if (uri.equals(requestUri)) {
                String a1 = HttpDigestHelper.getHashedSecret(username, guard);
                String a2 = Engine.getInstance().toMd5(request.getMethod() + ":" + requestUri);
                StringBuffer expectedResponse = new StringBuffer(a1).append(':').append(nonce);
                if (!AuthenticationUtils.anyNull(qop, cnonce, nc)) {
                    expectedResponse.append(':').append(nc).append(':').append(cnonce).append(':').append(qop);
                }
                expectedResponse.append(':').append(a2);
                if (response.equals(Engine.getInstance().toMd5(expectedResponse.toString()))) {
                    return 1;
                }
            }
            return -1;
        }
        return 0;
    }

    @Override
    public void challenge(Response response, boolean stale, Guard guard) {
        super.challenge(response, stale, guard);
        if (stale) {
            response.getAttributes().put("stale", "true");
        }
        Series parameters = response.getChallengeRequest().getParameters();
        StringBuffer domain = new StringBuffer();
        for (String baseUri : guard.getDomainUris()) {
            domain.append(baseUri).append(' ');
        }
        if (domain.length() > 0) {
            domain.delete(domain.length() - 1, domain.length());
            parameters.add("domain", domain.toString());
        }
        parameters.add("nonce", SecurityUtils.makeNonce(guard.getServerKey()));
        if (response.getAttributes().containsKey("stale")) {
            parameters.add("stale", "true");
        }
    }

    @Override
    public void formatCredentials(StringBuilder sb, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        Series params = challenge.getParameters();
        for (Parameter param : params) {
            sb.append(param.getName()).append('=');
            if (param.getName().equals("qop") || param.getName().equals("algorithm") || param.getName().equals("nc")) {
                sb.append(param.getValue()).append(",");
                continue;
            }
            sb.append('\"').append(param.getValue()).append('\"').append(",");
        }
        if (!params.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    @Override
    public void formatParameters(StringBuilder sb, Series<Parameter> parameters, ChallengeRequest request) {
        sb.append(", domain=\"").append(parameters.getFirstValue("domain")).append('\"');
        sb.append(", qop=\"auth\"");
        sb.append(", algorithm=MD5");
        sb.append(", nonce=\"").append(parameters.getFirstValue("nonce")).append('\"');
        if (parameters.getFirst("stale") != null) {
            sb.append(", stale=\"true\"");
        }
    }

    @Override
    public void parseResponse(ChallengeResponse cr, Request request, Logger logger) {
        AuthenticationUtils.parseParameters(cr.getCredentials(), (Series<Parameter>)cr.getParameters());
    }
}

