/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.component;

import com.noelios.restlet.TemplateDispatcher;
import com.noelios.restlet.component.ComponentContext;
import java.util.Iterator;
import org.restlet.Component;
import org.restlet.VirtualHost;
import org.restlet.data.LocalReference;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class ComponentClientDispatcher
extends TemplateDispatcher {
    public ComponentClientDispatcher(ComponentContext componentContext) {
        super(componentContext);
    }

    protected void doHandle(Request request, Response response) {
        Protocol protocol = request.getProtocol();
        if (protocol.equals((Object)Protocol.RIAP)) {
            request.setConfidential(true);
            LocalReference cr = new LocalReference(request.getResourceRef());
            Component component = this.getComponent();
            if (component != null) {
                if (cr.getRiapAuthorityType() == 5) {
                    request.getResourceRef().setBaseRef(request.getResourceRef().getHostIdentifier());
                    component.getInternalRouter().handle(request, response);
                } else if (cr.getRiapAuthorityType() == 6) {
                    VirtualHost host = null;
                    VirtualHost currentHost = null;
                    Integer hostHashCode = VirtualHost.getCurrent();
                    Iterator hostIter = this.getComponent().getHosts().iterator();
                    while (host == null && hostIter.hasNext()) {
                        currentHost = (VirtualHost)hostIter.next();
                        if (currentHost.hashCode() != hostHashCode.intValue()) continue;
                        host = currentHost;
                    }
                    if (host == null && component.getDefaultHost() != null && component.getDefaultHost().hashCode() == hostHashCode.intValue()) {
                        host = component.getDefaultHost();
                    }
                    if (host != null) {
                        request.getResourceRef().setBaseRef(request.getResourceRef().getHostIdentifier());
                        host.handle(request, response);
                    } else {
                        this.getLogger().warning("No virtual host is available to route the RIAP Host request.");
                    }
                } else {
                    this.getLogger().warning("Unknown RIAP authority. Only \"component\" is supported.");
                }
            } else {
                this.getLogger().warning("No compoent is available to route the RIAP request.");
            }
        } else {
            this.getComponentContext().getComponentHelper().getClientRouter().handle(request, response);
        }
    }

    private Component getComponent() {
        Component result = null;
        if (this.getComponentContext() != null && this.getComponentContext().getComponentHelper() != null) {
            result = (Component)this.getComponentContext().getComponentHelper().getHelped();
        }
        return result;
    }

    private ComponentContext getComponentContext() {
        return (ComponentContext)this.getContext();
    }
}

