/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.component;

import com.noelios.restlet.ChainHelper;
import com.noelios.restlet.StatusFilter;
import com.noelios.restlet.component.ClientRouter;
import com.noelios.restlet.component.ComponentContext;
import com.noelios.restlet.component.ComponentStatusFilter;
import com.noelios.restlet.component.ServerRouter;
import java.util.Iterator;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.Server;
import org.restlet.VirtualHost;
import org.restlet.data.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentHelper
extends ChainHelper<Component> {
    private volatile ClientRouter clientRouter = new ClientRouter((Component)this.getHelped());
    private volatile ServerRouter serverRouter = new ServerRouter((Component)this.getHelped());

    public ComponentHelper(Component component) {
        super(component);
    }

    private boolean checkVirtualHost(VirtualHost host) throws Exception {
        boolean result = true;
        if (host != null) {
            for (Route route : host.getRoutes()) {
                Iterator iter;
                Restlet next = route.getNext();
                if (!(next instanceof Application)) continue;
                Application application = (Application)next;
                for (Protocol clientProtocol : application.getConnectorService().getClientProtocols()) {
                    boolean clientFound = false;
                    iter = ((Component)this.getHelped()).getClients().iterator();
                    while (!clientFound && iter.hasNext()) {
                        Client client = (Client)iter.next();
                        clientFound = client.getProtocols().contains(clientProtocol);
                    }
                    if (clientFound) continue;
                    ((Component)this.getHelped()).getLogger().severe("Unable to start the application \"" + application.getName() + "\". Client connector for protocol " + clientProtocol.getName() + " is missing.");
                    result = false;
                }
                for (Protocol serverProtocol : application.getConnectorService().getServerProtocols()) {
                    boolean serverFound = false;
                    iter = ((Component)this.getHelped()).getServers().iterator();
                    while (!serverFound && iter.hasNext()) {
                        Server server = (Server)iter.next();
                        serverFound = server.getProtocols().contains(serverProtocol);
                    }
                    if (serverFound) continue;
                    ((Component)this.getHelped()).getLogger().severe("Unable to start the application \"" + application.getName() + "\". Server connector for protocol " + serverProtocol.getName() + " is missing.");
                    result = false;
                }
                if (!result || !application.isStopped()) continue;
                application.start();
            }
        }
        return result;
    }

    public Context createContext(String loggerName) {
        return new ComponentContext(this, Logger.getLogger(loggerName));
    }

    protected StatusFilter createStatusFilter(Component component) {
        return new ComponentStatusFilter(component);
    }

    public ClientRouter getClientRouter() {
        return this.clientRouter;
    }

    public ServerRouter getServerRouter() {
        return this.serverRouter;
    }

    public void setServerRouter(ServerRouter serverRouter) {
        this.serverRouter = serverRouter;
    }

    public synchronized void start() throws Exception {
        boolean success = this.checkVirtualHost(((Component)this.getHelped()).getDefaultHost());
        if (success) {
            for (VirtualHost host : ((Component)this.getHelped()).getHosts()) {
                success = success && this.checkVirtualHost(host);
            }
        }
        if (!success) {
            ((Component)this.getHelped()).stop();
        } else {
            if (((Component)this.getHelped()).getLogService().isEnabled()) {
                this.addFilter(this.createLogFilter(((Component)this.getHelped()).getContext(), ((Component)this.getHelped()).getLogService()));
            }
            if (((Component)this.getHelped()).getStatusService().isEnabled()) {
                this.addFilter(this.createStatusFilter((Component)this.getHelped()));
            }
            this.setNext((Restlet)this.getServerRouter());
        }
    }

    public synchronized void stop() throws Exception {
        this.getServerRouter().stop();
        this.stopVirtualHostApplications(((Component)this.getHelped()).getDefaultHost());
        for (VirtualHost host : ((Component)this.getHelped()).getHosts()) {
            this.stopVirtualHostApplications(host);
        }
    }

    private void stopVirtualHostApplications(VirtualHost host) throws Exception {
        for (Route route : host.getRoutes()) {
            if (!route.getNext().isStarted()) continue;
            route.getNext().stop();
        }
    }

    public void update() throws Exception {
        ServerRouter oldRouter = this.getServerRouter();
        this.setServerRouter(new ServerRouter((Component)this.getHelped()));
        this.setNext((Restlet)this.getServerRouter());
        if (oldRouter != null) {
            oldRouter.stop();
        }
    }
}

