/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.util.PreferenceReader;
import java.io.IOException;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;

public class ContentType {
    private volatile MediaType mediaType;
    private volatile CharacterSet characterSet;

    public ContentType(String headerValue) {
        try {
            this.mediaType = ContentType.parseContentType(headerValue);
            String charSet = this.mediaType.getParameters().getFirstValue("charset");
            if (charSet != null) {
                this.characterSet = new CharacterSet(charSet);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static MediaType parseContentType(String headerValue) throws IOException {
        PreferenceReader pr = new PreferenceReader(4, headerValue);
        Preference pref = pr.readPreference();
        return (MediaType)pref.getMetadata();
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public CharacterSet getCharacterSet() {
        return this.characterSet;
    }
}

