/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.service.ConnectorService;
import org.restlet.util.DateUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpCall {
    private volatile String clientAddress = null;
    private volatile int clientPort = -1;
    private volatile boolean confidential = false;
    private volatile String hostDomain = null;
    private volatile int hostPort = -1;
    private volatile Logger logger;
    private volatile String method = null;
    private volatile Protocol protocol = null;
    private volatile String reasonPhrase = "";
    private final Series<Parameter> requestHeaders = new Form();
    private volatile String requestUri = null;
    private final Series<Parameter> responseHeaders = new Form();
    private volatile String serverAddress = null;
    private volatile int serverPort = -1;
    private volatile int statusCode = 200;
    private volatile String version = null;

    public static String formatDate(Date date, boolean cookie) {
        if (cookie) {
            return DateUtils.format((Date)date, (String)((String)DateUtils.FORMAT_RFC_1036.get(0)));
        }
        return DateUtils.format((Date)date, (String)((String)DateUtils.FORMAT_RFC_1123.get(0)));
    }

    public static Date parseDate(String date, boolean cookie) {
        if (cookie) {
            return DateUtils.parse((String)date, (List)DateUtils.FORMAT_RFC_1036);
        }
        return DateUtils.parse((String)date, (List)DateUtils.FORMAT_RFC_1123);
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public ConnectorService getConnectorService(Request request) {
        ConnectorService result = null;
        Application application = Application.getCurrent();
        result = application != null ? application.getConnectorService() : new ConnectorService();
        return result;
    }

    protected long getContentLength(Series<Parameter> headers) {
        long contentLength = -1L;
        for (Parameter header : headers) {
            if (!header.getName().equalsIgnoreCase("Content-Length")) continue;
            try {
                contentLength = Long.parseLong(header.getValue());
            }
            catch (NumberFormatException e) {
                contentLength = -1L;
            }
        }
        return contentLength;
    }

    public String getHostDomain() {
        return this.hostDomain;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getMethod() {
        return this.method;
    }

    public Protocol getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.isConfidential() ? Protocol.HTTPS : Protocol.HTTP;
        }
        return this.protocol;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public Series<Parameter> getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public Series<Parameter> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getStatusCode() throws IOException {
        return this.statusCode;
    }

    public String getVersion() {
        return this.version;
    }

    protected abstract boolean isClientKeepAlive();

    public boolean isConfidential() {
        return this.confidential;
    }

    protected boolean isKeepAlive() {
        return this.isClientKeepAlive() && this.isServerKeepAlive();
    }

    protected boolean isRequestChunked() {
        String header = this.getRequestHeaders().getFirstValue("Transfer-Encoding", true);
        return header != null && header.equalsIgnoreCase("chunked");
    }

    protected boolean isResponseChunked() {
        String header = this.getResponseHeaders().getFirstValue("Transfer-Encoding", true);
        return header != null && header.equalsIgnoreCase("chunked");
    }

    protected abstract boolean isServerKeepAlive();

    protected void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    protected void setClientPort(int clientPort) {
        this.clientPort = clientPort;
    }

    protected void setConfidential(boolean confidential) {
        this.confidential = confidential;
    }

    public void setHostDomain(String hostDomain) {
        this.hostDomain = hostDomain;
    }

    public void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected void setMethod(String method) {
        this.method = method;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    protected void setRequestUri(String requestUri) {
        if (requestUri == null || requestUri.equals("")) {
            requestUri = "/";
        }
        this.requestUri = requestUri;
    }

    public void setServerAddress(String responseAddress) {
        this.serverAddress = responseAddress;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setStatusCode(int code) {
        this.statusCode = code;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

