/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.ContentType;
import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpClientHelper;
import com.noelios.restlet.util.HeaderReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.ReadableRepresentation;
import org.restlet.resource.Representation;
import org.restlet.service.ConnectorService;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpClientCall
extends HttpCall {
    private volatile HttpClientHelper helper;

    public static Representation copyResponseEntityHeaders(Iterable<Parameter> responseHeaders, Representation representation) throws NumberFormatException {
        Representation result = representation == null ? Representation.createEmpty() : representation;
        boolean entityHeaderFound = false;
        for (Parameter header : responseHeaders) {
            String value;
            HeaderReader hr;
            if (header.getName().equalsIgnoreCase("Content-Type")) {
                ContentType contentType = new ContentType(header.getValue());
                result.setMediaType(contentType.getMediaType());
                CharacterSet characterSet = contentType.getCharacterSet();
                if (characterSet != null) {
                    result.setCharacterSet(characterSet);
                }
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Length")) {
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Expires")) {
                result.setExpirationDate(HttpClientCall.parseDate(header.getValue(), false));
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Encoding")) {
                hr = new HeaderReader(header.getValue());
                value = hr.readValue();
                while (value != null) {
                    Encoding encoding = new Encoding(value);
                    if (!encoding.equals((Object)Encoding.IDENTITY)) {
                        result.getEncodings().add(encoding);
                    }
                    value = hr.readValue();
                }
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Language")) {
                hr = new HeaderReader(header.getValue());
                value = hr.readValue();
                while (value != null) {
                    result.getLanguages().add(new Language(value));
                    value = hr.readValue();
                }
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Last-Modified")) {
                result.setModificationDate(HttpClientCall.parseDate(header.getValue(), false));
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("ETag")) {
                result.setTag(Tag.parse((String)header.getValue()));
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Location")) {
                result.setIdentifier(header.getValue());
                entityHeaderFound = true;
                continue;
            }
            if (!header.getName().equalsIgnoreCase("Content-Disposition")) continue;
            result.setDownloadName(HttpClientCall.parseContentDisposition(header.getValue()));
            entityHeaderFound = true;
        }
        if (!entityHeaderFound) {
            return null;
        }
        return result;
    }

    public static String getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public static String parseContentDisposition(String value) {
        if (value != null) {
            String key = "FILENAME=\"";
            int index = value.toUpperCase().indexOf(key);
            if (index > 0) {
                return value.substring(index + key.length(), value.length() - 1);
            }
            key = "FILENAME=";
            index = value.toUpperCase().indexOf(key);
            if (index > 0) {
                return value.substring(index + key.length(), value.length());
            }
        }
        return null;
    }

    public HttpClientCall(HttpClientHelper helper, String method, String requestUri) {
        this.setLogger(helper == null ? null : helper.getLogger());
        this.helper = helper;
        this.setMethod(method);
        this.setRequestUri(requestUri);
        this.setClientAddress(HttpClientCall.getLocalAddress());
    }

    protected long getContentLength() {
        return this.getContentLength(this.getResponseHeaders());
    }

    public HttpClientHelper getHelper() {
        return this.helper;
    }

    protected Representation getRepresentation(InputStream stream) {
        return new InputRepresentation(stream, null);
    }

    protected Representation getRepresentation(ReadableByteChannel channel) {
        return new ReadableRepresentation(channel, null);
    }

    public abstract WritableByteChannel getRequestEntityChannel();

    public abstract OutputStream getRequestEntityStream();

    public abstract OutputStream getRequestHeadStream();

    public Representation getResponseEntity(Response response) {
        Representation result = null;
        long size = -1L;
        Series<Parameter> responseHeaders = this.getResponseHeaders();
        String transferEncoding = responseHeaders.getFirstValue("Transfer-Encoding", true);
        size = transferEncoding != null && !"identity".equalsIgnoreCase(transferEncoding) ? -1L : this.getContentLength();
        if (!(this.getMethod().equals(Method.HEAD.getName()) || response.getStatus().isInformational() || response.getStatus().equals((Object)Status.REDIRECTION_NOT_MODIFIED) || response.getStatus().equals((Object)Status.SUCCESS_NO_CONTENT) || response.getStatus().equals((Object)Status.SUCCESS_RESET_CONTENT) || response.getStatus().equals((Object)Status.SUCCESS_PARTIAL_CONTENT))) {
            InputStream stream = this.getUnClosedResponseEntityStream(this.getResponseEntityStream(size));
            ReadableByteChannel channel = this.getResponseEntityChannel(size);
            if (stream != null) {
                result = this.getRepresentation(stream);
            } else if (channel != null) {
                result = this.getRepresentation(channel);
            }
        }
        if ((result = HttpClientCall.copyResponseEntityHeaders(responseHeaders, result)) != null) {
            result.setSize(size);
            if (size == -1L) {
                this.getLogger().info("The length of the message body is unknown. The entity must be handled carefully and consumed entirely in order to surely release the connection.");
            }
        }
        return result;
    }

    public abstract ReadableByteChannel getResponseEntityChannel(long var1);

    public abstract InputStream getResponseEntityStream(long var1);

    private InputStream getUnClosedResponseEntityStream(InputStream inputStream) {
        InputStream result = null;
        if (inputStream != null) {
            try {
                if (inputStream.available() > 0) {
                    result = inputStream;
                } else {
                    PushbackInputStream is = new PushbackInputStream(inputStream);
                    int i = is.read();
                    if (i >= 0) {
                        is.unread(i);
                        result = is;
                    }
                }
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.FINER, "End of response entity stream.", ioe);
            }
        }
        return result;
    }

    @Override
    protected boolean isClientKeepAlive() {
        return true;
    }

    @Override
    protected boolean isServerKeepAlive() {
        String header = this.getResponseHeaders().getFirstValue("Connection", true);
        return header == null || !header.equalsIgnoreCase("close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status sendRequest(Request request) {
        Status result = null;
        Representation entity = request.isEntityAvailable() ? request.getEntity() : null;
        try {
            if (entity != null) {
                ConnectorService connectorService = this.getConnectorService(request);
                if (connectorService != null) {
                    connectorService.beforeSend(entity);
                }
                OutputStream rs = this.getRequestEntityStream();
                WritableByteChannel wbc = this.getRequestEntityChannel();
                if (wbc != null) {
                    entity.write(wbc);
                } else if (rs != null) {
                    entity.write(rs);
                    rs.flush();
                }
                if (connectorService != null) {
                    connectorService.afterSend(entity);
                }
                if (rs != null) {
                    rs.close();
                } else if (wbc != null) {
                    wbc.close();
                }
            }
            result = new Status(this.getStatusCode(), null, this.getReasonPhrase(), null);
        }
        catch (IOException ioe) {
            this.getHelper().getLogger().log(Level.WARNING, "An error occured during the communication with the remote HTTP server.", ioe);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)ioe);
        }
        finally {
            if (entity != null) {
                entity.release();
            }
        }
        return result;
    }

    protected boolean shouldRequestBeChunked(Request request) {
        return request.isEntityAvailable() && request.getEntity() != null && request.getEntity().getSize() == -1L;
    }
}

