/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.ContentType;
import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpUtils;
import com.noelios.restlet.util.HeaderReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.cert.Certificate;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Server;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.Parameter;
import org.restlet.data.Response;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.ReadableRepresentation;
import org.restlet.resource.Representation;
import org.restlet.service.ConnectorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpServerCall
extends HttpCall {
    private static final ConcurrentMap<String, Integer> keySizesCache = new ConcurrentHashMap<String, Integer>();
    private volatile boolean hostParsed;

    protected static Integer extractKeySize(String sslCipherSuite) {
        String encAlgorithm;
        int encAlgorithmIndex;
        Integer keySize = (Integer)keySizesCache.get(sslCipherSuite);
        if (keySize == null && (encAlgorithmIndex = sslCipherSuite.indexOf("WITH_")) >= 0 && (encAlgorithm = sslCipherSuite.substring(encAlgorithmIndex + 5)) != null) {
            if (encAlgorithm.startsWith("NULL_")) {
                keySize = 0;
            } else if (encAlgorithm.startsWith("IDEA_CBC_")) {
                keySize = 128;
            } else if (encAlgorithm.startsWith("RC2_CBC_40_")) {
                keySize = 40;
            } else if (encAlgorithm.startsWith("RC4_40_")) {
                keySize = 40;
            } else if (encAlgorithm.startsWith("RC4_128_")) {
                keySize = 128;
            } else if (encAlgorithm.startsWith("DES40_CBC_")) {
                keySize = 40;
            } else if (encAlgorithm.startsWith("DES_CBC_")) {
                keySize = 56;
            } else if (encAlgorithm.startsWith("3DES_EDE_CBC_")) {
                keySize = 168;
            } else {
                StringTokenizer st = new StringTokenizer(encAlgorithm, "_");
                while (st.hasMoreTokens()) {
                    try {
                        keySize = Integer.valueOf(st.nextToken());
                        break;
                    }
                    catch (NumberFormatException e) {
                    }
                }
            }
            if (keySize != null) {
                keySizesCache.put(sslCipherSuite, keySize);
            }
        }
        return keySize;
    }

    public static String formatContentDisposition(String fileName) {
        StringBuilder b = new StringBuilder("attachment; filename=\"");
        if (fileName != null) {
            b.append(fileName);
        }
        b.append('\"');
        return b.toString();
    }

    public HttpServerCall(Logger logger, String serverAddress, int serverPort) {
        this.setLogger(logger);
        this.setServerAddress(serverAddress);
        this.setServerPort(serverPort);
        this.hostParsed = false;
    }

    public HttpServerCall(Server server) {
        this(server.getLogger(), server.getAddress(), server.getPort());
    }

    public void complete() {
    }

    protected long getContentLength() {
        return this.getContentLength(this.getRequestHeaders());
    }

    @Override
    public String getHostDomain() {
        if (!this.hostParsed) {
            this.parseHost();
        }
        return super.getHostDomain();
    }

    @Override
    public int getHostPort() {
        if (!this.hostParsed) {
            this.parseHost();
        }
        return super.getHostPort();
    }

    public Representation getRequestEntity() {
        InputRepresentation result = null;
        long contentLength = this.getContentLength();
        InputStream requestStream = this.getRequestEntityStream(contentLength);
        ReadableByteChannel requestChannel = this.getRequestEntityChannel(contentLength);
        if (requestStream != null) {
            result = new InputRepresentation(requestStream, null, contentLength);
        } else if (requestChannel != null) {
            result = new ReadableRepresentation(requestChannel, null, contentLength);
        }
        result.setSize(contentLength);
        for (Parameter header : this.getRequestHeaders()) {
            String value;
            HeaderReader hr;
            if (header.getName().equalsIgnoreCase("Content-Encoding")) {
                hr = new HeaderReader(header.getValue());
                value = hr.readValue();
                while (value != null) {
                    Encoding encoding = Encoding.valueOf((String)value);
                    if (!encoding.equals((Object)Encoding.IDENTITY)) {
                        result.getEncodings().add(encoding);
                    }
                    value = hr.readValue();
                }
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Language")) {
                hr = new HeaderReader(header.getValue());
                value = hr.readValue();
                while (value != null) {
                    result.getLanguages().add(Language.valueOf((String)value));
                    value = hr.readValue();
                }
                continue;
            }
            if (!header.getName().equalsIgnoreCase("Content-Type")) continue;
            ContentType contentType = new ContentType(header.getValue());
            result.setMediaType(contentType.getMediaType());
            result.setCharacterSet(contentType.getCharacterSet());
        }
        return result;
    }

    public abstract ReadableByteChannel getRequestEntityChannel(long var1);

    public abstract InputStream getRequestEntityStream(long var1);

    public abstract ReadableByteChannel getRequestHeadChannel();

    public abstract InputStream getRequestHeadStream();

    public abstract WritableByteChannel getResponseEntityChannel();

    public abstract OutputStream getResponseEntityStream();

    public String getSslCipherSuite() {
        return null;
    }

    public List<Certificate> getSslClientCertificates() {
        return null;
    }

    public Integer getSslKeySize() {
        Integer keySize = null;
        String sslCipherSuite = this.getSslCipherSuite();
        if (sslCipherSuite != null) {
            keySize = HttpServerCall.extractKeySize(sslCipherSuite);
        }
        return keySize;
    }

    @Override
    protected boolean isClientKeepAlive() {
        String header = this.getRequestHeaders().getFirstValue("Connection", true);
        return header == null || !header.equalsIgnoreCase("close");
    }

    @Override
    protected boolean isServerKeepAlive() {
        return true;
    }

    private void parseHost() {
        String host = this.getRequestHeaders().getFirstValue("Host", true);
        if (host != null) {
            int colonIndex = host.indexOf(58);
            if (colonIndex != -1) {
                super.setHostDomain(host.substring(0, colonIndex));
                super.setHostPort(Integer.valueOf(host.substring(colonIndex + 1)));
            } else {
                super.setHostDomain(host);
                super.setHostPort(this.getProtocol().getDefaultPort());
            }
        } else {
            this.getLogger().info("Couldn't find the mandatory \"Host\" HTTP header.");
        }
        this.hostParsed = true;
    }

    protected void readRequestHead(InputStream headStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        int next = headStream.read();
        while (next != -1 && !HttpUtils.isSpace(next)) {
            sb.append((char)next);
            next = headStream.read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the request method. End of stream reached too early.");
        }
        this.setMethod(sb.toString());
        sb.delete(0, sb.length());
        next = headStream.read();
        while (next != -1 && !HttpUtils.isSpace(next)) {
            sb.append((char)next);
            next = headStream.read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the request URI. End of stream reached too early.");
        }
        this.setRequestUri(sb.toString());
        sb.delete(0, sb.length());
        next = headStream.read();
        while (next != -1 && !HttpUtils.isCarriageReturn(next)) {
            sb.append((char)next);
            next = headStream.read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the HTTP version. End of stream reached too early.");
        }
        next = headStream.read();
        if (HttpUtils.isLineFeed(next)) {
            this.setVersion(sb.toString());
            sb.delete(0, sb.length());
            Parameter header = HttpUtils.readHeader(headStream, sb);
            while (header != null) {
                this.getRequestHeaders().add((Object)header);
                header = HttpUtils.readHeader(headStream, sb);
            }
        } else {
            throw new IOException("Unable to parse the HTTP version. The carriage return must be followed by a line feed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(Response response) throws IOException {
        if (response != null) {
            Representation entity;
            try {
                this.writeResponseHead(response);
                entity = response.getEntity();
                if (entity != null) {
                    ConnectorService connectorService = this.getConnectorService(response.getRequest());
                    if (connectorService != null) {
                        connectorService.beforeSend(entity);
                    }
                    WritableByteChannel responseEntityChannel = this.getResponseEntityChannel();
                    OutputStream responseEntityStream = this.getResponseEntityStream();
                    this.writeResponseBody(entity, responseEntityChannel, responseEntityStream);
                    if (connectorService != null) {
                        connectorService.afterSend(entity);
                    }
                    if (responseEntityStream != null) {
                        try {
                            responseEntityStream.flush();
                            responseEntityStream.close();
                        }
                        catch (IOException ioe) {
                            this.getLogger().log(Level.FINE, "Exception while flushing and closing the entity stream.", ioe);
                        }
                    }
                }
            }
            finally {
                entity = response.getEntity();
                if (entity != null) {
                    entity.release();
                }
            }
        }
    }

    protected boolean shouldResponseBeChunked(Response response) {
        return response.getEntity() != null && response.getEntity().getSize() == -1L;
    }

    public void writeResponseBody(Representation entity, WritableByteChannel responseEntityChannel, OutputStream responseEntityStream) throws IOException {
        if (responseEntityChannel != null) {
            entity.write(responseEntityChannel);
        } else if (responseEntityStream != null) {
            entity.write(responseEntityStream);
        }
    }

    public void writeResponseHead(Response response) throws IOException {
    }

    protected void writeResponseHead(Response response, OutputStream headStream) throws IOException {
        String version = this.getVersion() == null ? "1.1" : this.getVersion();
        headStream.write(version.getBytes());
        headStream.write(32);
        headStream.write(Integer.toString(this.getStatusCode()).getBytes());
        headStream.write(32);
        if (this.getReasonPhrase() != null) {
            headStream.write(this.getReasonPhrase().getBytes());
        } else {
            headStream.write(("Status " + this.getStatusCode()).getBytes());
        }
        headStream.write(13);
        headStream.write(10);
        this.getResponseHeaders().set("Connection", "close", this.isServerKeepAlive());
        if (this.shouldResponseBeChunked(response)) {
            this.getResponseHeaders().add("Transfer-Encoding", "chunked");
        }
        for (Parameter header : this.getResponseHeaders()) {
            HttpUtils.writeHeader(header, headStream);
        }
        headStream.write(13);
        headStream.write(10);
    }
}

