/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.HttpServerCall;
import com.noelios.restlet.http.InputEntityStream;
import com.noelios.restlet.util.ChunkedInputStream;
import com.noelios.restlet.util.ChunkedOutputStream;
import com.noelios.restlet.util.KeepAliveOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.restlet.Server;
import org.restlet.data.Response;
import org.restlet.util.ByteUtils;

public class StreamServerCall
extends HttpServerCall {
    private volatile InputStream requestEntityStream;
    private final InputStream requestStream;
    private volatile OutputStream responseEntityStream;
    private final OutputStream responseStream;
    private final Socket socket;

    public StreamServerCall(Server server, InputStream requestStream, OutputStream responseStream, Socket socket) {
        super(server);
        this.requestStream = requestStream;
        this.responseStream = responseStream;
        this.responseEntityStream = null;
        this.requestEntityStream = null;
        this.socket = socket;
        try {
            this.readRequestHead(this.getRequestHeadStream());
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to parse the HTTP request", ioe);
        }
    }

    public void complete() {
        try {
            this.socket.getOutputStream().flush();
            ByteUtils.exhaust((InputStream)this.getRequestEntityStream(this.getContentLength()));
            if (!this.socket.isClosed()) {
                this.socket.shutdownOutput();
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.WARNING, "Unable to shutdown server socket", ex);
        }
    }

    public String getClientAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public int getClientPort() {
        return this.socket.getPort();
    }

    public ReadableByteChannel getRequestEntityChannel(long size) {
        return null;
    }

    public InputStream getRequestEntityStream(long size) {
        if (this.requestEntityStream == null) {
            this.requestEntityStream = this.isRequestChunked() ? new ChunkedInputStream(this.getRequestStream()) : new InputEntityStream(this.getRequestStream(), size);
        }
        return this.requestEntityStream;
    }

    public ReadableByteChannel getRequestHeadChannel() {
        return null;
    }

    public InputStream getRequestHeadStream() {
        return this.getRequestStream();
    }

    private InputStream getRequestStream() {
        return this.requestStream;
    }

    public WritableByteChannel getResponseEntityChannel() {
        return null;
    }

    public OutputStream getResponseEntityStream() {
        if (this.responseEntityStream == null) {
            this.responseEntityStream = this.isResponseChunked() ? new ChunkedOutputStream(this.getResponseStream()) : new KeepAliveOutputStream(this.getResponseStream());
        }
        return this.responseEntityStream;
    }

    private OutputStream getResponseStream() {
        return this.responseStream;
    }

    protected boolean isServerKeepAlive() {
        return false;
    }

    public void writeResponseHead(Response response) throws IOException {
        this.writeResponseHead(response, this.getResponseStream());
    }
}

